package com.particle.api.infrastructure.db.table

import android.os.Parcelable
import androidx.annotation.Keep
import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.TypeConverters
import com.particle.api.infrastructure.net.data.resp.DeserializedData
import kotlinx.android.parcel.Parcelize

@Keep
enum class DeserializedDataType(val value: String) {
    Rss3NativeSend("rss3_native_send"),
    Rss3NativeReceive("rss3_native_receive"),
    NativeSend("native_send"),
    NativeReceive("native_receive"),
    Rss3TokenSend("rss3_token_send"),
    Rss3TokenReceive("rss3_token_receive"),
    Rss3Erc20Approve("rss3_erc_20_approve"),
    Rss3Erc20Burn("rss3_erc_20_burn"),
    Rss3NftSend("rss3_nft_send"),
    Rss3NftReceive("rss3_nft_receive"),
    Rss3NftApprove("rss3_nft_approve"),
    Rss3NftMint("rss3_nft_mint"),
    Rss3NftBuy("rss3_nft_buy"),
    Rss3Swap("rss3_swap"),
    Other("other"),
}

@Parcelize
@TypeConverters(DeserializedDataConverter::class)
@Entity(
    tableName = "trans_info_evm", primaryKeys = ["publicKey", "chainName", "chainId", "hash"]
)
data class TransInfoEvm(
    @ColumnInfo(name = "publicKey") var publicKey: String,
    @ColumnInfo(name = "chainName") var chainName: String,
    @ColumnInfo(name = "chainId") var chainId: Long,
    @ColumnInfo(name = "from") var from: String?,
    @ColumnInfo(name = "to") var to: String?,
    @ColumnInfo(name = "hash") var hash: String,
    @ColumnInfo(name = "value") var value: String?,
    @ColumnInfo(name = "data") var data: String?,
    @ColumnInfo(name = "gasLimit") var gasLimit: String?,
    @ColumnInfo(name = "gasSpent") var gasSpent: String?,
    @ColumnInfo(name = "gasPrice") var gasPrice: String?,
    @ColumnInfo(name = "fees") var fees: String?,
    @ColumnInfo(name = "type") var type: Int?,
    @ColumnInfo(name = "nonce") var nonce: String?,
    @ColumnInfo(name = "maxPriorityFeePerGas") var maxPriorityFeePerGas: String?,
    @ColumnInfo(name = "maxFeePerGas") var maxFeePerGas: String?,
    @ColumnInfo(name = "timestamp") var timestamp: Long,
    @ColumnInfo(name = "status") var status: Int?,
    @ColumnInfo(name = "deserializedData") var deserializedData: DeserializedData?,
) : Parcelable {
    enum class Status(val num: Int) {
        Local(0), Pending(1), Success(3), Failed(4)
    }

}