package com.particle.api.infrastructure.db.table

import android.os.Parcelable
import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.TypeConverter
import androidx.room.TypeConverters
import com.blankj.utilcode.util.GsonUtils
import com.particle.api.infrastructure.net.data.resp.DeserializedData
import com.particle.api.infrastructure.net.data.resp.TransResultData
import kotlinx.android.parcel.Parcelize

enum class TransStatus {
    ALL, OUT, IN, FAILED,
}

class TransResultDataConverter {

    @TypeConverter
    fun stringToObj(string: String?): TransResultData? {
        return GsonUtils.fromJson(string, TransResultData::class.java)
    }

    @TypeConverter
    fun objToString(data: TransResultData?): String? {
        return GsonUtils.toJson(data)
    }
}
class DeserializedDataConverter {

    @TypeConverter
    fun stringToObj(string: String?): DeserializedData? {
        return GsonUtils.fromJson(string, DeserializedData::class.java)
    }

    @TypeConverter
    fun objToString(data: DeserializedData?): String? {
        return GsonUtils.toJson(data)
    }
}

enum class TransInfoInOutStatus {
    SEND, RECEIVE, FAILED, UNKNOWN
}

@Parcelize
@TypeConverters(TransResultDataConverter::class)
@Entity(tableName = "trans_info", primaryKeys = ["publicKey", "chainName", "chainId", "signature"])
data class TransInfo(
    @ColumnInfo(name = "publicKey") var publicKey: String,
    @ColumnInfo(name = "chainName") var chainName: String,
    @ColumnInfo(name = "chainId") var chainId: Long,
    @ColumnInfo(name = "type") var type: String?,
    @ColumnInfo(name = "lamportsChange") var lamportsChange: Long,
    @ColumnInfo(name = "lamportsFee") var lamportsFee: Long,
    @ColumnInfo(name = "signature") var signature: String,
    @ColumnInfo(name = "blockTime") var blockTime: Long,
    @ColumnInfo(name = "status") var status: String,
    @ColumnInfo(name = "data") var data: TransResultData?,
    @ColumnInfo(name = "mint") var mint: String?,
    @ColumnInfo(name = "from") var from: String?,
    @ColumnInfo(name = "to") var to: String?,
    @ColumnInfo(name = "amountTransfered") val amountTransfered: Long?,
    @ColumnInfo(name = "lamportsTransfered") val lamportsTransfered: Long?,
) : Parcelable {
    enum class Type(val value: String) {
        Unknown("unknown"),
        TransferSol("transfer-sol"),
        TransferToken("transfer-token")
    }
}