package com.particle.api.infrastructure.db.table

import android.os.Parcelable
import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.TypeConverters
import com.particle.api.infrastructure.db.dao.converter.BigIntegerConverter
import kotlinx.android.parcel.Parcelize
import java.math.BigDecimal
import java.math.BigInteger
import kotlin.math.pow

@Parcelize
@TypeConverters(BigIntegerConverter::class)
@Entity(tableName = "token_info", primaryKeys = ["publicKey", "chainName", "chainId", "address"])
data class TokenInfo(
    @ColumnInfo(name = "publicKey") val publicKey: String,
    @ColumnInfo(name = "chainName") val chainName: String,
    @ColumnInfo(name = "chainId") var chainId: Long,
    @ColumnInfo(name = "address") var address: String,
    @ColumnInfo(name = "tokenSymbol", defaultValue = "") var tokenSymbol: String?,
    @ColumnInfo(name = "amount", defaultValue = "0") var amount: BigInteger,
    @ColumnInfo(name = "decimals", defaultValue = "0") var decimals: Int,
    @ColumnInfo(name = "displayState", defaultValue = "0") var displayState: Int,
    @ColumnInfo(name = "updateTime", defaultValue = "0") var updateTime: Long,
    @ColumnInfo(name = "divideDecimals", defaultValue = "0") var divideDecimals: BigInteger,
) : Parcelable {
    fun new(): TokenInfo {
        return TokenInfo(
            this.publicKey,
            this.chainName,
            this.chainId,
            this.address,
            this.tokenSymbol,
            this.amount,
            this.decimals,
            this.displayState,
            this.updateTime,
            BigDecimal.valueOf(10.0.pow(this.decimals.toDouble())).toBigInteger()
        )
    }

    override fun equals(other: Any?): Boolean {

        if (javaClass != other?.javaClass) return false
        other as TokenInfo
        if (publicKey != other.publicKey) return false
        if (chainName != other.chainName) return false
        if (chainId != other.chainId) return false
        if (address != other.address) return false

        return true
    }

    fun isNative(): Boolean {
        return address == "native"
    }



}