package com.particle.api.infrastructure.db.table

import android.os.Parcelable
import androidx.room.ColumnInfo
import androidx.room.Entity
import kotlinx.android.parcel.Parcelize

enum class SplTokenSource(val index: Int) {
    SUSPICIOUS(-1),
    Particle(0),
    UserAdd(1);

    companion object {
        fun all(): List<Int> {
            return listOf(-1, 0, 1)
        }

        fun hiddenSuspicious(): List<Int> {
            return listOf(0, 1)
        }
    }

}

@Parcelize
@Entity(tableName = "spl_token", primaryKeys = ["chainName", "chainId", "address"])
data class SplToken(
    @ColumnInfo(name = "chainName") var chainName: String,
    @ColumnInfo(name = "chainId") var chainId: Long,
    @ColumnInfo(name = "address") var address: String,
    @ColumnInfo(name = "symbol") var symbol: String,
    @ColumnInfo(name = "decimals") var decimals: Int,
    @ColumnInfo(name = "name") var name: String,
    @ColumnInfo(name = "logoURI", defaultValue = "") var logoURI: String,
    @ColumnInfo(name = "source") var source: Int = 0,
) : Parcelable