package com.particle.api.infrastructure.db.table

import androidx.room.ColumnInfo
import androidx.room.Entity

@Entity(tableName = "rates", primaryKeys = ["chainName", "chainId", "address"])
data class Rates(
    @ColumnInfo(name = "chainName") val chainName: String,
    @ColumnInfo(name = "chainId") val chainId: Long,
    @ColumnInfo(name = "address") val address: String,
    @ColumnInfo(name = "type") val type: String,
    @ColumnInfo(name = "rate", defaultValue = "0") val rate: Double,
    @ColumnInfo(name = "market_cap") val marketCap: Double,
    @ColumnInfo(name = "change24") val change24: Double,
    @ColumnInfo(name = "vol24h") val vol24h: Double,
    @ColumnInfo(name = "lastUpdated") val lastUpdated: Double,
)

