package com.particle.api.infrastructure.db.table

import android.text.TextUtils
import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.TypeConverter
import androidx.room.TypeConverters
import com.blankj.utilcode.util.GsonUtils
import com.particle.api.infrastructure.net.data.resp.MetaData
import com.particle.api.infrastructure.net.data.resp.NFTData

class TokenNFTListDataConverter {

    @TypeConverter
    fun stringToObj(string: String?): MetaData? {
        return GsonUtils.fromJson(string, MetaData::class.java)
    }

    @TypeConverter
    fun objToString(data: MetaData?): String? {
        return GsonUtils.toJson(data)
    }

    @TypeConverter
    fun evmStringToObj(string: String?): NFTData? {
        return GsonUtils.fromJson(string, NFTData::class.java)
    }

    @TypeConverter
    fun evmObjToString(data: NFTData?): String? {
        return GsonUtils.toJson(data)
    }
}

@TypeConverters(TokenNFTListDataConverter::class)
@Entity(tableName = "nft_info", primaryKeys = ["chainName", "chainId", "mint", "tokenId"])
data class NftInfo(
    @ColumnInfo(name = "chainName") val chainName: String,
    @ColumnInfo(name = "chainId") var chainId: Long,
    @ColumnInfo(name = "mint") val mint: String,
    @ColumnInfo(name = "image") var image: String,
    @ColumnInfo(name = "symbol") var symbol: String,
    @ColumnInfo(name = "name") var name: String,
    @ColumnInfo(name = "sellerFeeBasisPoints") var sellerFeeBasisPoints: Int?,
    @ColumnInfo(name = "description") var description: String?,
    @ColumnInfo(name = "externalUrl") var externalUrl: String?,
    @ColumnInfo(name = "animationUrl") var animationUrl: String?,
    @ColumnInfo(name = "solData") var solData: MetaData?,
    @ColumnInfo(name = "evmData") var evmData: NFTData?,

    @ColumnInfo(name = "isSemiFungible") var isSemiFungible: Boolean?,
    @ColumnInfo(name = "tokenId") var tokenId: String,
    @ColumnInfo(name = "tokenBalance") var tokenBalance: Int?,
    @ColumnInfo(name = "isScam") var isScam: Int = 0,
) {
    fun is3d(): Boolean {
        return if (!animationUrl.isNullOrEmpty()) {
            animationUrl!!.endsWith("glb", true) || animationUrl!!.endsWith("gltf", true)
        } else {
            false
        }
    }

    fun isScamNFT():Boolean{
        return isScam == 1
    }
    fun getNftName(): String {
        return if (!TextUtils.isEmpty(name)) {
            name
        } else {
            "NFT#$tokenId"
        }
    }

}