package com.particle.api.infrastructure.db.table

import androidx.room.ColumnInfo
import androidx.room.Entity

@Entity(tableName = "address_info", primaryKeys = ["publicKey", "chain", "address"])
data class AddressInfo(
    @ColumnInfo(name = "publicKey") val publicKey: String,
    @ColumnInfo(name = "chain") val chain: String,
    @ColumnInfo(name = "address") val address: String,
    @ColumnInfo(name = "name") val name: String,
    @ColumnInfo(name = "createdTime") val createdTime: Long,
    @ColumnInfo(name = "updateTime") val updateTime: Long,
    @ColumnInfo(name = "sortKey", defaultValue = "0") val sortStatue: Long?,
)

