package com.particle.api.infrastructure.db.dao

import androidx.room.*
import androidx.room.OnConflictStrategy.Companion.REPLACE
import com.particle.api.infrastructure.db.table.WalletInfo

@Dao
interface WalletInfoDao {


    //add wallet
    @Insert(onConflict = REPLACE)
    suspend fun addWallet(wallet: WalletInfo)

    //update wallet
    @Update(onConflict = REPLACE)
    suspend fun updateWallet(wallet: WalletInfo)

    @Query("delete FROM wallet_info where walletName=:walletName")
    suspend fun deleteWalletByType(walletName: String)

    @Query("delete FROM wallet_info where address=:address and walletName=:walletName")
    suspend fun deleteWallet(address: String, walletName: String)

    @Query("delete FROM wallet_info where address=:address")
    suspend fun deleteWallet(address: String)

    @Query("delete FROM wallet_info where walletName=:walletName")
    suspend fun deleteWalletByWalletName(walletName: String)

    @Query("SELECT * FROM wallet_info WHERE walletName = :walletName order by updateTime")
    suspend fun getWalletByType(walletName: String): List<WalletInfo>

    @Query("SELECT * FROM wallet_info WHERE walletName = :walletName order by updateTime desc")
    suspend fun getWalletByName(walletName: String): List<WalletInfo>

    @Query("SELECT * FROM wallet_info WHERE walletName in (:walletNames) order by updateTime desc,sortKey desc")
    suspend fun getConnectWallet(walletNames: List<String>): List<WalletInfo>

    @Query("SELECT * FROM wallet_info WHERE walletName in (:walletName) order by sortKey asc")
    suspend fun getConnectWalletBySortKey(walletName: List<String>): List<WalletInfo>

    @Query("SELECT EXISTS (SELECT * from wallet_info where address=:address and walletName=:walletName)")
    suspend fun isAddressExist(address: String, walletName: String): Boolean

    @Query("SELECT * FROM wallet_info order by updateTime")
    suspend fun getAllWallets(): List<WalletInfo>

    @Query("SELECT * FROM wallet_info WHERE walletName = :walletName order by updateTime")
    suspend fun getAllWalletsByType(walletName: String): List<WalletInfo>

    @Query("Update wallet_info set isSelected = 0 ")
    suspend fun updateSelectedStatus()

    @Query("SELECT * FROM wallet_info WHERE isSelected = 1")
    suspend fun getSelectedWallet(): WalletInfo?

    @Query("SELECT * FROM wallet_info WHERE address=:address and walletName = :walletName ")
    suspend fun getWallet(address: String, walletName: String): WalletInfo?

}