package com.particle.api.infrastructure.db.dao

import androidx.paging.PagingSource
import androidx.room.*
import androidx.room.OnConflictStrategy.Companion.REPLACE
import com.particle.api.infrastructure.db.table.TransInfo

@Dao
interface TransDao {


    @Query("SELECT * FROM trans_info where publicKey=:publicKey and chainName =:chainName and chainId=:chainId order by blockTime desc ")
    fun getAllTrans(
        publicKey: String,
        chainName: String,
        chainId: Long,
    ): PagingSource<Int, TransInfo>

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and mint=:mint order by blockTime desc ")
    fun getAllTransByMint(
        publicKey: String,
        chainName: String,
        chainId: Long,
        mint: String
    ): PagingSource<Int, TransInfo>

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and ((`from` = :from and IFNULL(lamportsTransfered,0)>0) or (`to`=:from and IFNULL(lamportsTransfered,0)<0)) order by blockTime desc")
    fun getOutTrans(
        publicKey: String,
        chainName: String,
        chainId: Long,
        from: String
    ): PagingSource<Int, TransInfo>

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and `from` = :from and upper(mint)=upper(:mint) and ((`from` = :from and IFNULL(amountTransfered,0)>0) or (`to`=:from and IFNULL(amountTransfered,0)<0))  order by blockTime desc")
    fun getOutTransByMint(
        publicKey: String,
        chainName: String,
        chainId: Long,
        from: String,
        mint: String
    ): PagingSource<Int, TransInfo>

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and upper(`to`) = upper(:to) and ((`from` = :to and IFNULL(lamportsTransfered,0)<=0) or (`to`=:to and IFNULL(lamportsTransfered,0)>=0)) order by blockTime desc")
    fun getInTrans(
        publicKey: String,
        chainName: String,
        chainId: Long,
        to: String
    ): PagingSource<Int, TransInfo>

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and `to` = :to and upper(mint)=upper(:mint) and ((`from` = :to and IFNULL(amountTransfered,0)<=0) or (`to`=:to and IFNULL(amountTransfered,0)>=0)) order by blockTime desc")
    fun getInTransByMint(
        publicKey: String,
        chainName: String,
        chainId: Long,
        to: String,
        mint: String
    ): PagingSource<Int, TransInfo>

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and status = 'failed' order by blockTime desc")
    fun getFailTrans(
        publicKey: String,
        chainName: String,
        chainId: Long
    ): PagingSource<Int, TransInfo>

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and status = 'failed' and upper(mint)=upper(:mint) order by blockTime desc")
    fun getFailTransByMint(
        publicKey: String,
        chainName: String,
        chainId: Long,
        mint: String
    ): PagingSource<Int, TransInfo>

    @Query("SELECT signature from trans_info ORDER by blockTime LIMIT 1")
    suspend fun getOldestSignature(): String?

    @Insert(onConflict = REPLACE)
    suspend fun insertAll(tokens: List<TransInfo>)

    @Insert(onConflict = REPLACE)
    suspend fun insert(token: TransInfo)

    @Update
    suspend fun update(token: TransInfo)

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId order by blockTime desc ")
    suspend fun testGetAllTrans(
        publicKey: String,
        chainName: String,
        chainId: Long,
    ): List<TransInfo>

    @Delete
    suspend fun delete(token: TransInfo)

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId order by blockTime desc ")
    suspend fun getAllSolTrans(
        publicKey: String,
        chainName: String,
        chainId: Long,
    ): List<TransInfo>

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and mint=:mint order by blockTime desc ")
    suspend fun getAllTokenTrans(
        publicKey: String,
        chainName: String,
        chainId: Long,
        mint: String
    ): List<TransInfo>

    @Query("SELECT * FROM trans_info where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId order by blockTime desc ")
    suspend fun getRecentTran(
        publicKey: String,
        chainName: String,
        chainId: Long,
    ): TransInfo?
}