package com.particle.api.infrastructure.db.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy.Companion.REPLACE
import androidx.room.Query
import com.particle.api.infrastructure.db.result.SplTokenJoinTokenInfo
import com.particle.api.infrastructure.db.result.SplTokenJoinTokenInfoRate
import com.particle.api.infrastructure.db.table.SplToken

@Dao
interface SplTokenDao {

    @Insert(onConflict = REPLACE)
    suspend fun insertAll(splTokens: List<SplToken>)

    @Insert(onConflict = REPLACE)
    suspend fun insert(splToken: SplToken)

    //1. 10
    //2.Added Token -1->未勾选,2->已勾选
    //3. 20
    //4.未添加 0-> 未勾选, 1->已勾选
    //5.Hidden Token: -2->隐藏的Token -3->需要在界面退出时重置成 2
    @Query(
        "SELECT tb2.*,tb1.displayState FROM token_info as tb1 " +
                "LEFT JOIN spl_token as tb2 on tb1.chainName = tb2.chainName and tb1.chainId= tb2.chainId and upper(tb1.address) = upper(tb2.address) " +
                "where tb1.chainName=:chainName and tb1.chainId = :chainId and tb1.displayState= 10  " +

                "UNION ALL SELECT tb1.*,tb2.displayState FROM spl_token as tb1 " +
                "LEFT JOIN token_info as tb2 on tb1.chainName = tb2.chainName and tb1.chainId=tb2.chainId and upper(tb1.address) = upper(tb2.address) " +
                "where tb2.publicKey=:publicKey and  tb1.chainName=:chainName and tb1.chainId = :chainId and tb1.address!='native' " +
                "and (tb2.displayState= -1 or tb2.displayState = 2)  and (symbol like :symbolName||'%' or name like :symbolName||'%' ) and tb1.source in (:sources) " +

                "UNION ALL SELECT tb2.*,tb1.displayState FROM token_info as tb1 " +
                "LEFT JOIN spl_token as tb2 on tb1.chainName = tb2.chainName and tb1.chainId=tb2.chainId and upper(tb1.address) = upper(tb2.address) " +
                "where tb1.chainName=:chainName and tb1.chainId = :chainId and tb1.displayState= 20  " +

                "UNION ALL SELECT tb1.*,tb2.displayState FROM spl_token as tb1 " +
                "LEFT JOIN token_info as tb2 on tb1.chainName = tb2.chainName and tb1.chainId=tb2.chainId and upper(tb1.address) = upper(tb2.address) and upper(tb2.publicKey)=upper(:publicKey) " +
                "where  tb1.chainName=:chainName and tb1.chainId = :chainId and upper(tb1.address)!=upper('native') " +
                "and (tb2.displayState= 1 or tb2.displayState = 0 or tb2.displayState is NULL) and (symbol like :symbolName||'%' or name like :symbolName||'%' )   and tb1.source in (:sources) "
    )
    fun getPagingSourceByLike(
        publicKey: String,
        chainName: String,
        chainId: Long,
        symbolName: String,
        sources: List<Int>
    ): PagingSource<Int, SplTokenJoinTokenInfo>


    @Query(
        "SELECT tb1.*,tb2.displayState FROM spl_token as tb1 " +
                "LEFT JOIN token_info as tb2 on tb1.chainName = tb2.chainName and tb1.chainId=tb2.chainId and tb1.address = tb2.address " +
                "where tb1.chainName=:chainName and tb1.chainId = :chainId and (tb2.displayState= -1 or tb2.displayState = 2)  and (symbol like '%'||:symbolName||'%' or name like '%'||:symbolName||'%' )"
    )
    fun getPagingSourceTokenAddedByLike(
        chainName: String,
        chainId: Long,
        symbolName: String
    ): PagingSource<Int, SplTokenJoinTokenInfo>

    @Query(
        "select spl.symbol symbol,spl.logoURI logoURI,spl.decimals decimals,token.amount amount,spl.address address, rates.rate rate ,token.amount*rates.rate total from spl_token spl " +
                "LEFT JOIN token_info token on spl.chainName =  token.chainName and spl.chainId = token.chainId and upper(token.address) = upper(spl.address) and upper(token.publicKey) =upper(:publicKey) " +
                "LEFT JOIN rates rates on rates.chainName = spl.chainName and rates.chainId = spl.chainId and upper(rates.address) = upper(spl.address) " +
                "where spl.chainName = :chainName and upper(spl.address)!=upper(:ignoreAddress) and upper(spl.address)!=upper(:wSOL)  " +
                "and  (token.displayState= 1 or token.displayState = 0 or token.displayState = 2  or token.displayState is NULL)  " +
                "and spl.chainId=:chainId and (spl.symbol like :symbolName||'%') " +
                "and spl.source in (:sources) " +
                "order by upper(token.address) = upper('native') desc,total desc, token.amount desc,token.updateTime desc "
    )
    fun getSplTokenJoinTokenInfoRates(
        publicKey: String,
        chainName: String,
        chainId: Long,
        symbolName: String,
        ignoreAddress: String,
        wSOL: String = "So11111111111111111111111111111111111111112",
        sources: List<Int>
    ): PagingSource<Int, SplTokenJoinTokenInfoRate>

    @Query("SELECT * from spl_token where chainName=:chainName and chainId=:chainId and address = :address")
    suspend fun getSplToken(
        chainName: String,
        chainId: Long,
        address: String
    ): SplToken?

    @Query("SELECT logoURI from spl_token where upper(chainName)=upper(:chainName) and chainId=:chainId and upper(address) = upper(:address)")
    suspend fun getImageURI(
        chainName: String,
        chainId: Long,
        address: String
    ): String?

    @Query("delete from spl_token where chainName=:chainName")
    suspend fun deleteByChainName(chainName: String)

    @Query("SELECT * from spl_token where chainName=:chainName and chainId=:chainId ")
    suspend fun getTokenList(
        chainName: String,
        chainId: Long
    ): List<SplToken>

    @Query("SELECT EXISTS (SELECT * from spl_token where chainName=:chainName and chainId=:chainId and address = :address)")
    suspend fun isAddressExist(chainName: String, chainId: Long, address: String): Boolean


    @Query(
        "SELECT tb1.*,tb2.displayState FROM spl_token as tb1 " +
                "LEFT JOIN token_info as tb2 on tb1.chainName = tb2.chainName and tb1.chainId=tb2.chainId and tb1.address = tb2.address and tb2.publicKey=:publicKey " +
                "where  tb1.chainName=:chainName and tb1.chainId = :chainId and tb1.address!='native' and (tb2.displayState= -2 or tb2.displayState = -3)   and tb1.source in (:sources) "
    )
    fun getPagingSourceHiddenToken(
        publicKey: String,
        chainName: String,
        chainId: Long,
        sources: List<Int>
    ): PagingSource<Int, SplTokenJoinTokenInfo>


    @Query(
        "select spl.symbol symbol,spl.logoURI logoURI,spl.decimals decimals,token.amount amount,spl.address address, rates.rate rate ,token.amount*rates.rate total from spl_token spl " +
                "LEFT JOIN token_info token on spl.chainName =  token.chainName and spl.chainId = token.chainId and upper(token.address) = upper(spl.address) and upper(token.publicKey) =upper(:publicKey) " +
                "LEFT JOIN rates rates on rates.chainName = spl.chainName and rates.chainId = spl.chainId and upper(rates.address) = upper(spl.address) " +
                "where spl.chainName = :chainName and upper(spl.address)!=upper(:ignoreAddress) and upper(spl.address)!=upper(:wSOL)  " +
                "and  (token.displayState= 1 or token.displayState = 0 or token.displayState = 2  or token.displayState is NULL)  " +
                "and spl.chainId=:chainId and (spl.symbol like :symbolName||'%') " +
                "and spl.source in (:sources) " +
                "order by upper(token.address) =upper('native') desc,total desc, token.amount desc,token.updateTime desc "
    )
    suspend fun getSplTokenJoinTokenInfoRatesList(
        publicKey: String,
        chainName: String,
        chainId: Long,
        symbolName: String,
        ignoreAddress: String,
        wSOL: String = "So11111111111111111111111111111111111111112",
        sources: List<Int>
    ): List<SplTokenJoinTokenInfoRate>
}