package com.particle.api.infrastructure.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import com.particle.api.infrastructure.db.table.Rates

@Dao
interface RatesDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertAll(rates: List<Rates>)

    @Query("select rate from rates where chainName = :chainName  and chainId=:chainId and upper(address) = upper(:address)")
    suspend fun getRate(chainName: String, chainId: Long, address: String): Double?

    @Query("delete from rates where chainName = :chainName  and chainId=:chainId")
    suspend fun deleteAll(chainName: String, chainId: Long)
}