package com.particle.api.infrastructure.db.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.OnConflictStrategy.Companion.REPLACE
import androidx.room.Query
import com.particle.api.infrastructure.db.table.NftInfo


@Dao
interface NftInfoDao {
    @Query("SELECT * FROM nft_info where chainName=:chainName and chainId=:chainId")
    suspend fun getAll(
        chainName: String,
        chainId: Long
    ): List<NftInfo>

    @Query("SELECT * FROM nft_info where chainName=:chainName and chainId=:chainId order by name ")
    fun getPagingSource(
        chainName: String,
        chainId: Long
    ): PagingSource<Int, NftInfo>

    @Query("SELECT * FROM nft_info where chainName=:chainName and chainId=:chainId and mint in (:displayNftContractList) order by name ")
    fun getPagingSourceByDisplayNFTContractAddress(
        chainName: String,
        chainId: Long,
        displayNftContractList: List<String>
    ): PagingSource<Int, NftInfo>

    @Query("SELECT * FROM nft_info where chainName=:chainName and chainId=:chainId  order by mint in (:priorityNFTContractList) desc ")
    fun getPagingSourcePriorityNFTContractList(
        chainName: String,
        chainId: Long,
        priorityNFTContractList: List<String>
    ): PagingSource<Int, NftInfo>

    @Query("SELECT * FROM nft_info where chainName=:chainName and chainId=:chainId and mint=:mint and tokenId=:tokenId")
    suspend fun getNftByMintTokenId(
        chainName: String,
        chainId: Long,
        mint: String,
        tokenId: String
    ): NftInfo

    @Query("SELECT * FROM nft_info where chainName=:chainName and chainId=:chainId and mint=:mint")
    suspend fun getNftByMint(
        chainName: String,
        chainId: Long,
        mint: String
    ): NftInfo?

    @Insert(onConflict = REPLACE)
    suspend fun insertAll(users: List<NftInfo>)

    @Delete
    suspend fun delete(user: NftInfo)

    @Query("DELETE FROM nft_info")
    suspend fun deleteAll()

    @Query("SELECT * FROM nft_info where chainName=:chainName and chainId=:chainId order by name ")
    suspend fun getAllNfts(
        chainName: String,
        chainId: Long
    ): List<NftInfo>
}