package com.particle.api.infrastructure.db.dao

import androidx.lifecycle.LiveData
import androidx.room.*
import androidx.room.OnConflictStrategy.Companion.REPLACE
import com.particle.api.infrastructure.db.table.KeyValue

enum class KVType(val value: String) {
    SearchHistory("search_history"),
    DeepBrowserApprovedAddress("deep_browser_approved_address"),
    HasSetPaymentPassword("has_set_payment_password"),
    DappApprovedSessionId("dapp_approved_sessionid"),
}

@Dao
interface KVDao {

    //add wallet
    @Insert(onConflict = REPLACE)
    suspend fun insert(wallet: KeyValue)

    @Query("DELETE FROM key_value where type =:type and `key` = :key")
    suspend fun deleteItem(type: String, key: String)

    @Query("DELETE FROM key_value where type =:type")
    suspend fun deleteAll(type: String)

    @Query("DELETE FROM key_value")
    suspend fun cleanAll()

    @Query("SELECT * FROM key_value where type =:type order by time desc")
    suspend fun getAll(type: String): List<KeyValue>

    @Query("SELECT EXISTS (SELECT * from key_value where `key`=:host and type=:type)")
    suspend fun isWebsiteApproved(type: String, host: String): Boolean
    @Query("SELECT EXISTS (SELECT * from key_value where `key`=:key and type=:type)")
    suspend fun isDAppApprovedSessionId(type: String, key: String): Boolean

    @Query("SELECT * FROM key_value where type ='has_set_payment_password'")
    fun liveDataHasSetPaymentPassword(): LiveData<KeyValue?>

    @Query("SELECT * FROM key_value where key ='has_set_payment_password'")
    suspend fun hasSetPaymentPassword(): KeyValue?

    @Query("SELECT * FROM key_value where key ='has_set_master_password'")
    suspend fun hasSetMasterPassword(): KeyValue?
}