package com.particle.api.infrastructure.db.dao

import androidx.paging.PagingSource
import androidx.room.*
import androidx.room.OnConflictStrategy.Companion.REPLACE
import com.particle.api.infrastructure.db.table.TransInfoEvm

@Dao
interface EvmTransDao {


    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId order by timestamp desc")
    fun getAllTrans(
        publicKey: String,
        chainName: String,
        chainId: Long,
    ): PagingSource<Int, TransInfoEvm>

    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and upper(`to`)=upper(:to) order by timestamp desc, status asc ")
    fun getAllTransByMint(
        publicKey: String,
        chainName: String,
        chainId: Long,
        to: String
    ): PagingSource<Int, TransInfoEvm>

    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and upper(`from`) = upper(:from)  order by timestamp desc, status asc")
    fun getOutTrans(
        publicKey: String,
        chainName: String,
        chainId: Long, from: String
    ): PagingSource<Int, TransInfoEvm>

    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and upper(`from`) = upper(:from) and upper(`to`)=upper(:to) order by timestamp desc, status asc")
    fun getOutTransByMint(
        publicKey: String,
        chainName: String,
        chainId: Long, from: String,
        to: String
    ): PagingSource<Int, TransInfoEvm>

    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and upper(`from`) != upper(:from)  order by timestamp desc, status asc")
    fun getInTrans(
        publicKey: String,
        chainName: String,
        chainId: Long,
        from: String
    ): PagingSource<Int, TransInfoEvm>

    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and upper(`from`) != upper(:from) and upper(`to`)=upper(:to) order by timestamp desc, status asc")
    fun getInTransByMint(
        publicKey: String,
        chainName: String,
        chainId: Long,
        from: String,
        to: String
    ): PagingSource<Int, TransInfoEvm>

    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and status = 4 order by timestamp desc, status asc")
    fun getFailTrans(
        publicKey: String,
        chainName: String,
        chainId: Long
    ): PagingSource<Int, TransInfoEvm>

    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and status = 4 and upper(`to`)=upper(:to) order by timestamp desc, status asc")
    fun getFailTransByMint(
        publicKey: String,
        chainName: String,
        chainId: Long,
        to: String
    ): PagingSource<Int, TransInfoEvm>

    @Query("SELECT hash from trans_info_evm ORDER by timestamp LIMIT 1")
    suspend fun getOldestSignature(): String?

    @Insert(onConflict = REPLACE)
    suspend fun insertAll(tokens: List<TransInfoEvm>)

    @Insert(onConflict = REPLACE)
    suspend fun insert(token: TransInfoEvm)

    @Update
    suspend fun update(token: TransInfoEvm)


    @Delete
    suspend fun delete(token: TransInfoEvm)

    @Query("delete from trans_info_evm where status == 0 or status ==1 ")
    suspend fun deleteAllTempTrans()


    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId order by timestamp desc,status asc ")
    suspend fun getAllEvmTrans(
        publicKey: String,
        chainName: String,
        chainId: Long,
    ): List<TransInfoEvm>

    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and upper(`to`)=upper(:to) order by timestamp desc, status asc ")
    suspend fun getAllEvmTransByMint(
        publicKey: String,
        chainName: String,
        chainId: Long,
        to: String
    ): List<TransInfoEvm>

    @Query("SELECT * FROM trans_info_evm where upper(publicKey)=upper(:publicKey) and chainName =:chainName and chainId=:chainId and upper(`to`)!=upper(:publicKey) order by status asc ,timestamp desc limit 1")
    suspend fun getRecentTran(
        publicKey: String,
        chainName: String,
        chainId: Long,
    ): TransInfoEvm?
}