package com.particle.api.infrastructure.db.dao

import androidx.paging.PagingSource
import androidx.room.*
import com.particle.api.infrastructure.db.table.AddressInfo

@Dao
interface AddressInfoDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(address: AddressInfo)


    @Query("SELECT * FROM address_info where publicKey=:publicKey and chain=:chain order by createdTime desc")
    fun getAllAddressInfo(
        publicKey: String,
        chain: String
    ): PagingSource<Int, AddressInfo>


    @Query("SELECT * FROM address_info where publicKey=:publicKey and chain=:chain and address=:address order by createdTime")
    suspend fun getAddressInfoByAddress(
        publicKey: String,
        chain: String,
        address: String
    ): AddressInfo?

    @Query("delete  FROM address_info where publicKey=:publicKey and chain=:chain and address=:address")
    suspend fun deleteAddressInfoByAddress(
        publicKey: String,
        chain: String,
        address: String
    )
}