package com.particle.api.infrastructure.db

import androidx.room.Database
import androidx.room.RoomDatabase
import com.particle.api.infrastructure.db.PNDatabase.Companion.DATABASE_VERSION
import com.particle.api.infrastructure.db.dao.AddressInfoDao
import com.particle.api.infrastructure.db.dao.EvmTransDao
import com.particle.api.infrastructure.db.dao.KVDao
import com.particle.api.infrastructure.db.dao.NftInfoDao
import com.particle.api.infrastructure.db.dao.RatesDao
import com.particle.api.infrastructure.db.dao.SplTokenDao
import com.particle.api.infrastructure.db.dao.TokenInfoDao
import com.particle.api.infrastructure.db.dao.TransDao
import com.particle.api.infrastructure.db.dao.WalletInfoDao
import com.particle.api.infrastructure.db.table.AddressInfo
import com.particle.api.infrastructure.db.table.KeyValue
import com.particle.api.infrastructure.db.table.NftInfo
import com.particle.api.infrastructure.db.table.Rates
import com.particle.api.infrastructure.db.table.SplToken
import com.particle.api.infrastructure.db.table.TokenInfo
import com.particle.api.infrastructure.db.table.TransInfo
import com.particle.api.infrastructure.db.table.TransInfoEvm
import com.particle.api.infrastructure.db.table.WalletInfo

@Database(
    entities = [TokenInfo::class, TransInfoEvm::class, NftInfo::class, TransInfo::class, SplToken::class,
        Rates::class, AddressInfo::class, WalletInfo::class, KeyValue::class],
    version = DATABASE_VERSION,
    exportSchema = false
)
abstract class PNDatabase : RoomDatabase() {
    companion object {
        const val DATABASE_VERSION = 8
        const val DATABASE_NAME = "pd.db"
    }

    abstract fun tokenInfoDao(): TokenInfoDao

    abstract fun tokenTransDao(): TransDao

    abstract fun evmTokenTransDao(): EvmTransDao

    abstract fun nftDao(): NftInfoDao

    abstract fun splTokenDao(): SplTokenDao

    abstract fun ratesDao(): RatesDao

    abstract fun addressInfoDao(): AddressInfoDao

    abstract fun walletInfoDao(): WalletInfoDao

    abstract fun kvDao(): KVDao
}