package com.particle.api.infrastructure.db

import androidx.room.Room
import com.blankj.utilcode.util.Utils
import com.particle.api.infrastructure.db.DBMIGRATIONScripts.MIGRATION_1_2
import com.particle.api.infrastructure.db.DBMIGRATIONScripts.MIGRATION_3_4
import com.particle.api.infrastructure.db.DBMIGRATIONScripts.MIGRATION_4_5
import com.particle.api.infrastructure.db.DBMIGRATIONScripts.MIGRATION_5_6
import com.particle.api.infrastructure.db.DBMIGRATIONScripts.MIGRATION_6_7
import com.particle.api.infrastructure.db.DBMIGRATIONScripts.MIGRATION_7_8
import com.particle.base.ParticleNetwork
import java.util.concurrent.Executors

object DBMananger {
    var database: PNDatabase = Room
        .databaseBuilder(
            Utils.getApp(),
            PNDatabase::class.java,
            PNDatabase.DATABASE_NAME
        )
        .addMigrations(MIGRATION_1_2, MIGRATION_3_4, MIGRATION_4_5, MIGRATION_5_6, MIGRATION_6_7, MIGRATION_7_8)
        .fallbackToDestructiveMigration()
        .setQueryExecutor(Executors.newCachedThreadPool())
        .build()


}
//CREATE TEMPORARY TABLE temp_token_info AS SELECT * FROM token_info;
//DROP TABLE token_info;
//CREATE TABLE token_info (
//publicKey TEXT NOT NULL,
//chainName TEXT NOT NULL,
//chainId INTEGER NOT NULL,
//address TEXT NOT NULL,
//tokenSymbol TEXT DEFAULT '',
//amount TEXT NOT NULL DEFAULT '0',
//decimals INTEGER NOT NULL DEFAULT 0,
//displayState INTEGER NOT NULL DEFAULT 0,
//updateTime INTEGER NOT NULL DEFAULT 0,
//divideDecimals TEXT NOT NULL DEFAULT '0',
//walletType TEXT,
//PRIMARY KEY(publicKey, chainName, chainId, address, amount)
//);
//INSERT INTO token_info SELECT * FROM temp_token_info;
//DROP TABLE temp_token_info;