package com.particle.api.infrastructure.db

import androidx.room.migration.Migration
import androidx.sqlite.db.SupportSQLiteDatabase


internal object DBMIGRATIONScripts {

    val MIGRATION_1_2: Migration = object : Migration(1, 2) {
        override fun migrate(database: SupportSQLiteDatabase) {
            //add wallet table
            database.execSQL("CREATE TABLE `wallet` ( `address` TEXT NOT NULL, `type` TEXT NOT NULL, `chainName` TEXT NOT NULL, `chainId` Integer NOT NULL, `name` TEXT, `privateKey` TEXT,PRIMARY KEY(`address`,`type`)) ")
        }
    }
    val MIGRATION_3_4: Migration = object : Migration(3, 4) {
        override fun migrate(database: SupportSQLiteDatabase) {
            database.execSQL("CREATE TABLE `key_value` ( `type` TEXT NOT NULL, `key` TEXT NOT NULL, `value` TEXT , `time` Integer NOT NULL,   PRIMARY KEY(`type`,`key`))")
        }
    }
    val MIGRATION_4_5: Migration = object : Migration(4, 5) {
        override fun migrate(database: SupportSQLiteDatabase) {
            database.execSQL(""" ALTER TABLE `spl_token` ADD COLUMN `source` INTEGER NOT NULL DEFAULT 0 """)
            database.execSQL(""" CREATE TABLE `wallet_info`  (`address` TEXT NOT NULL, `walletName` TEXT NOT NULL, `chainName` TEXT NOT NULL, `chainId` INTEGER NOT NULL, `name` TEXT, `isSelected` INTEGER NOT NULL DEFAULT 0, `updateTime` INTEGER NOT NULL DEFAULT 0, `sortKey` INTEGER NOT NULL DEFAULT 0, PRIMARY KEY(`address`, `walletName`))""")
            database.execSQL(
                """
                  INSERT INTO `wallet_info` (`address`, `walletName`, `chainName`, `chainId`, `name`, `isSelected`, `updateTime`, `sortKey`)
                  SELECT `address`,
                      CASE
                          WHEN `type` = 'PN_WALLET' THEN 'Particle'
                          WHEN `type` = 'ETH_IMPORT' THEN 'EVM Connect'
                          WHEN `type` = 'SOL_IMPORT' THEN 'Solana Connect'
                          WHEN `type` = 'CONNET_METAMASK' THEN 'MetaMask'
                          WHEN `type` = 'CONNET_RAINBOW' THEN 'Rainbow'
                          WHEN `type` = 'CONNET_TRUST' THEN 'Trust'
                          WHEN `type` = 'CONNET_IMTOKEN' THEN 'ImToken'
                          WHEN `type` = 'CONNET_BITKEEP' THEN 'BitKeep'
                          WHEN `type` = 'CONNET_WALLET' THEN 'WalletConnect'
                          WHEN `type` = 'CONNET_PHANTOM' THEN 'Phantom'
                          ELSE `type`
                      END,
                  `chainName`,
                  CASE 
                        WHEN chainName = 'Solana' AND chainIdName = 'Mainnet' THEN 101
                        WHEN chainName = 'Solana' AND chainIdName = 'Testnet' THEN 102
                        WHEN chainName = 'Solana' AND chainIdName = 'Devnet' THEN 103
                        WHEN chainName = 'Ethereum' AND chainIdName = 'Mainnet' THEN 1
                        WHEN chainName = 'Ethereum' AND chainIdName = 'Goerli' THEN 5
                        WHEN chainName = 'Ethereum' AND chainIdName = 'Sepolia' THEN 11155111
                        WHEN chainName = 'BSC' AND chainIdName = 'Mainnet' THEN 56
                        WHEN chainName = 'BSC' AND chainIdName = 'Testnet' THEN 97
                        WHEN chainName = 'Polygon' AND chainIdName = 'Mainnet' THEN 137
                        WHEN chainName = 'Polygon' AND chainIdName = 'Mumbai' THEN 80001
                        WHEN chainName = 'Avalanche' AND chainIdName = 'Mainnet' THEN 43114
                        WHEN chainName = 'Avalanche' AND chainIdName = 'Testnet' THEN 43113
                        WHEN chainName = 'Fantom' AND chainIdName = 'Mainnet' THEN 250
                        WHEN chainName = 'Fantom' AND chainIdName = 'Testnet' THEN 4002
                        WHEN chainName = 'Arbitrum' AND chainIdName = 'One' THEN 42161
                        WHEN chainName = 'Arbitrum' AND chainIdName = 'Nova' THEN 42170
                        WHEN chainName = 'Arbitrum' AND chainIdName = 'Goerli' THEN 421613
                        WHEN chainName = 'Moonbeam' AND chainIdName = 'Mainnet' THEN 1284
                        WHEN chainName = 'Moonbeam' AND chainIdName = 'Testnet' THEN 1287
                        WHEN chainName = 'Moonriver' AND chainIdName = 'Mainnet' THEN 1285
                        WHEN chainName = 'Moonriver' AND chainIdName = 'Testnet' THEN 1287
                        WHEN chainName = 'Heco' AND chainIdName = 'Mainnet' THEN 128
                        WHEN chainName = 'Aurora' AND chainIdName = 'Mainnet' THEN 1313161554
                        WHEN chainName = 'Aurora' AND chainIdName = 'Testnet' THEN 1313161555
                        WHEN chainName = 'Optimism' AND chainIdName = 'Mainnet' THEN 10
                        WHEN chainName = 'Optimism' AND chainIdName = 'Goerli' THEN 420
                        WHEN chainName = 'KCC' AND chainIdName = 'Mainnet' THEN 321
                        WHEN chainName = 'KCC' AND chainIdName = 'Testnet' THEN 322
                        WHEN chainName = 'Harmony' AND chainIdName = 'Mainnet' THEN 1666600000
                        WHEN chainName = 'Harmony' AND chainIdName = 'Testnet' THEN 1666700000
                        WHEN chainName = 'PlatON' AND chainIdName = 'Mainnet' THEN 210425
                        WHEN chainName = 'PlatON' AND chainIdName = 'Testnet' THEN 2206132
                        WHEN chainName = 'Tron' AND chainIdName = 'Mainnet' THEN 728126428
                        WHEN chainName = 'Tron' AND chainIdName = 'Shasta' THEN 2494104990
                        WHEN chainName = 'Tron' AND chainIdName = 'Nile' THEN 3448148188
                        WHEN chainName = 'OKC' AND chainIdName = 'Mainnet' THEN 66
                        WHEN chainName = 'OKC' AND chainIdName = 'Testnet' THEN 65
                        WHEN chainName = 'ThunderCore' AND chainIdName = 'Mainnet' THEN 108
                        WHEN chainName = 'ThunderCore' AND chainIdName = 'Testnet' THEN 18
                        WHEN chainName = 'Cronos' AND chainIdName = 'Mainnet' THEN 25
                        WHEN chainName = 'Cronos' AND chainIdName = 'Testnet' THEN 338
                        WHEN chainName = 'OasisEmerald' AND chainIdName = 'Mainnet' THEN 42262
                        WHEN chainName = 'OasisEmerald' AND chainIdName = 'Testnet' THEN 42261
                        WHEN chainName = 'Gnosis' AND chainIdName = 'Mainnet' THEN 100
                        WHEN chainName = 'Gnosis' AND chainIdName = 'Testnet' THEN 10200
                        WHEN chainName = 'Celo' AND chainIdName = 'Mainnet' THEN 42220
                        WHEN chainName = 'Celo' AND chainIdName = 'Testnet' THEN 44787
                        WHEN chainName = 'Klaytn' AND chainIdName = 'Mainnet' THEN 8217
                        WHEN chainName = 'Klaytn' AND chainIdName = 'Testnet' THEN 1001
                         ELSE 1
                      END,
                  `name`,
                  `isSelected`,
                  `updateTime`,
                  `sortKey`
                  FROM `wallet`
                        """
            )

            database.execSQL("DROP TABLE `wallet`")
        }
    }

    val MIGRATION_5_6: Migration = object : Migration(5, 6) {
        override fun migrate(database: SupportSQLiteDatabase) {
            database.execSQL(""" ALTER TABLE `nft_info` ADD COLUMN `isScam` INTEGER NOT NULL DEFAULT 0 """)
        }
    }
    val MIGRATION_6_7: Migration = object : Migration(6, 7) {
        override fun migrate(database: SupportSQLiteDatabase) {
            database.execSQL(" ALTER TABLE `trans_info_evm` ADD COLUMN `deserializedData` TEXT  ")
        }
    }
    val MIGRATION_7_8: Migration = object : Migration(7, 8) {
        override fun migrate(database: SupportSQLiteDatabase) {
            database.execSQL(" ALTER TABLE `wallet_info` ADD COLUMN `aaName` TEXT  DEFAULT 'Smart Account' ")
            database.execSQL("UPDATE `wallet_info` SET `aaName` = 'Smart Account'")
        }
    }


}
