package com.particle.api

import androidx.annotation.Keep
import com.particle.api.service.CommonAPIService
import com.particle.api.service.EvmService
import com.particle.api.service.NetService
import com.particle.api.service.SolanaService
import com.particle.base.ParticleNetwork


val ParticleNetwork.solana: SolanaService
    get() {
        return NetService.solana
    }


val ParticleNetwork.evm: EvmService
    get() {
        return NetService.evmService
    }

val ParticleNetwork.commonApi: CommonAPIService
    get() {
        return NetService.commonApiService
    }
@Keep
object ParticleNetworkApi {
    var priorityTokenAddresses: List<String> = mutableListOf()
}