/*
 * Decompiled with CFR 0.152.
 */
package net.technearts.blns;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;

public class BlnsArgumentProvider
implements ArgumentsProvider {
    private static final Logger LOGGER = Logger.getLogger("Blns Logger");
    private JSONArray jsonArray;

    public BlnsArgumentProvider() {
        JSONParser parser = new JSONParser();
        try {
            InputStream is = this.getClass().getResourceAsStream("/blns.json");
            Object obj = parser.parse((Reader)new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8), 8192));
            this.jsonArray = (JSONArray)obj;
        }
        catch (Exception e) {
            LOGGER.severe("File blns.json not found! This is unexpected.");
            e.printStackTrace();
        }
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) {
        return Stream.of(this.jsonArray.toArray()).map(s -> Arguments.of((Object[])new Object[]{s.toString()}));
    }

    public Stream<String> provideStrings() {
        return Stream.of(this.jsonArray.toArray()).map(Object::toString);
    }
}

