/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import java.util.HashMap;
import java.util.Map;

public class UserAgentUtil {
    public static Map<String, String> getUserAgent(String userAgent) {
        if (userAgent == null || "".equals(userAgent)) {
            return null;
        }
        if (userAgent.contains("Windows")) {
            if (userAgent.contains("Windows NT 6.2")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "8", "");
            }
            if (userAgent.contains("Windows NT 6.1")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "7", "");
            }
            if (userAgent.contains("Windows NT 6.0")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "Vista", "");
            }
            if (userAgent.contains("Windows NT 5.2")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "XP", "x64 Edition");
            }
            if (userAgent.contains("Windows NT 5.1")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "XP", "");
            }
            if (userAgent.contains("Windows NT 5.01")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "2000", "SP1");
            }
            if (userAgent.contains("Windows NT 5.0")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "2000", "");
            }
            if (userAgent.contains("Windows NT 4.0")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "NT 4.0", "");
            }
            if (userAgent.contains("Windows 98; Win 9x 4.90")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "ME", "");
            }
            if (userAgent.contains("Windows 98")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "98", "");
            }
            if (userAgent.contains("Windows 95")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "95", "");
            }
            if (userAgent.contains("Windows CE")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "CE", "");
            }
        } else if (userAgent.contains("Mac OS X")) {
            if (userAgent.contains("iPod")) {
                return UserAgentUtil.judgeBrowser(userAgent, "iPod", null, null);
            }
            if (userAgent.contains("Macintosh")) {
                String version = userAgent.substring(userAgent.indexOf("Mac OS X ") + 9, userAgent.indexOf("Mac OS X ") + 13);
                return UserAgentUtil.judgeBrowser(userAgent, "Macintosh", "Mac OS X", version);
            }
        }
        return null;
    }

    private static Map<String, String> judgeBrowser(String userAgent, String platformType, String platformSeries, String platformVersion) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (userAgent.contains("Chrome")) {
            String temp = userAgent.substring(userAgent.indexOf("Chrome/") + 7);
            String chromeVersion = null;
            chromeVersion = temp.indexOf(" ") < 0 ? temp : temp.substring(0, temp.indexOf(" "));
            map.put("browserType", "Chrome");
            map.put("browserVersion", chromeVersion);
            map.put("platformType", platformType);
            map.put("platformSeries", platformSeries);
            map.put("platformVersion", platformVersion);
            return map;
        }
        if (userAgent.contains("Firefox")) {
            String temp = userAgent.substring(userAgent.indexOf("Firefox/") + 8);
            String ffVersion = null;
            ffVersion = temp.indexOf(" ") < 0 ? temp : temp.substring(0, temp.indexOf(" "));
            map.put("browserType", "Firefox");
            map.put("browserVersion", ffVersion);
            map.put("platformType", platformType);
            map.put("platformSeries", platformSeries);
            map.put("platformVersion", platformVersion);
            return map;
        }
        if (userAgent.contains("MSIE")) {
            String ie = null;
            String iev = null;
            if (userAgent.contains("MSIE 10.0")) {
                ie = "Internet Explorer";
                iev = "10";
            } else if (userAgent.contains("MSIE 9.0")) {
                ie = "Internet Explorer";
                iev = "9";
            } else if (userAgent.contains("MSIE 8.0")) {
                ie = "Internet Explorer";
                iev = "8";
            } else if (userAgent.contains("MSIE 7.0")) {
                ie = "Internet Explorer";
                iev = "7";
            } else if (userAgent.contains("MSIE 6.0")) {
                ie = "Internet Explorer";
                iev = "6";
            }
            map.put("browserType", ie);
            map.put("browserVersion", iev);
            map.put("platformType", platformType);
            map.put("platformSeries", platformSeries);
            map.put("platformVersion", platformVersion);
        } else {
            map.put("browserType", null);
            map.put("browserVersion", null);
            map.put("platformType", platformType);
            map.put("platformSeries", platformSeries);
            map.put("platformVersion", platformVersion);
        }
        return map;
    }
}

