/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class RedisUtils {
    static final Logger logger = LoggerFactory.getLogger(RedisUtils.class);
    private static RedisUtils redis = new RedisUtils();
    private static final String CONFIG_FILE = "config.properties";
    private static JedisPool jedisPool;

    public static RedisUtils getInstance() {
        return redis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long expire(String key, int seconds) {
        if (key == null || key.equals("")) {
            return 0L;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            long l = jedis.expire(key, seconds);
            return l;
        }
        catch (Exception ex) {
            logger.error("EXPIRE error[key=" + key + " seconds=" + seconds + "]" + ex.getMessage(), (Throwable)ex);
            jedisPool.returnBrokenResource(jedis);
        }
        finally {
            jedisPool.returnResource(jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long expireAt(String key, int unixTimestamp) {
        if (key == null || key.equals("")) {
            return 0L;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            long l = jedis.expireAt(key, (long)unixTimestamp);
            return l;
        }
        catch (Exception ex) {
            logger.error("EXPIRE error[key=" + key + " unixTimestamp=" + unixTimestamp + "]" + ex.getMessage(), (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String trimList(String key, long start, long end) {
        if (key == null || key.equals("")) {
            return "-";
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            String string = jedis.ltrim(key, start, end);
            return string;
        }
        catch (Exception ex) {
            logger.error("LTRIM \u51fa\u9519[key=" + key + " start=" + start + " end=" + end + "]" + ex.getMessage(), (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return "-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countSet(String key) {
        if (key == null) {
            return 0L;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            long l = jedis.scard(key);
            return l;
        }
        catch (Exception ex) {
            logger.error("countSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return 0L;
    }

    public boolean addSet(String key, int seconds, String ... value) {
        boolean result = this.addSet(key, value);
        if (result) {
            long i = this.expire(key, seconds);
            return i == 1L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSet(String key, String ... value) {
        if (key == null || value == null) {
            return false;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.sadd(key, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("setList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsInSet(String key, String value) {
        if (key == null || value == null) {
            return false;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            boolean bl = jedis.sismember(key, value);
            return bl;
        }
        catch (Exception ex) {
            logger.error("setList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSet(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Set set = jedis.smembers(key);
            return set;
        }
        catch (Exception ex) {
            logger.error("getList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSetValue(String key, String ... value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.srem(key, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("getList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countZSet(String key) {
        if (key == null) {
            return 0L;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            long l = jedis.zcard(key);
            return l;
        }
        catch (Exception ex) {
            logger.error("countSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return 0L;
    }

    public int removeListValue(String key, List<String> values) {
        return this.removeListValue(key, 1L, values);
    }

    public int removeListValue(String key, long count, List<String> values) {
        int result = 0;
        if (values != null && values.size() > 0) {
            for (String value : values) {
                if (!this.removeListValue(key, count, value)) continue;
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListValue(String key, long count, String value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.lrem(key, count, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("getList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] lpopBytes(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            byte[] byArray = jedis.lpop(key.getBytes());
            return byArray;
        }
        catch (Exception ex) {
            logger.error("getList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpushBytes(String key, byte[] value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Long l = jedis.rpush(key.getBytes(), (byte[][])new byte[][]{value});
            return l;
        }
        catch (Exception ex) {
            logger.error("getList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> rangeList(String key, long start, long end) {
        if (key == null || key.equals("")) {
            return null;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            List list = jedis.lrange(key, start, end);
            return list;
        }
        catch (Exception ex) {
            logger.error("rangeList \u51fa\u9519[key=" + key + " start=" + start + " end=" + end + "]" + ex.getMessage(), (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countList(String key) {
        if (key == null) {
            return 0L;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            long l = jedis.llen(key);
            return l;
        }
        catch (Exception ex) {
            logger.error("countList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return 0L;
    }

    public boolean addList(String key, int seconds, String ... value) {
        boolean result = this.addList(key, value);
        if (result) {
            long i = this.expire(key, seconds);
            return i == 1L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addList(String key, String ... value) {
        if (key == null || value == null) {
            return false;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.lpush(key, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("setList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    public boolean addList(String key, List<String> list) {
        if (key == null || list == null || list.size() == 0) {
            return false;
        }
        for (String value : list) {
            this.addList(key, value);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getList(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            List list = jedis.lrange(key, 0L, -1L);
            return list;
        }
        catch (Exception ex) {
            logger.error("getList error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setHSet(String domain, String key, String value) {
        if (value == null) {
            return false;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.hset(domain, key, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("setHSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hmset(String key, Map<String, String> map) {
        if (map == null) {
            return false;
        }
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.hmset(key, map);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("setHMSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHSet(String domain, String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            String string = jedis.hget(domain, key);
            return string;
        }
        catch (Exception ex) {
            logger.error("getHSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delHSet(String domain, String key) {
        Jedis jedis = null;
        long count = 0L;
        try {
            jedis = jedisPool.getResource();
            count = jedis.hdel(domain, new String[]{key});
        }
        catch (Exception ex) {
            logger.error("delHSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delHSet(String domain, String ... key) {
        Jedis jedis = null;
        long count = 0L;
        try {
            jedis = jedisPool.getResource();
            count = jedis.hdel(domain, key);
        }
        catch (Exception ex) {
            logger.error("delHSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsHSet(String domain, String key) {
        Jedis jedis = null;
        boolean isExist = false;
        try {
            jedis = jedisPool.getResource();
            isExist = jedis.hexists(domain, key);
        }
        catch (Exception ex) {
            logger.error("existsHSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hvals(String domain) {
        Jedis jedis = null;
        List retList = null;
        try {
            jedis = jedisPool.getResource();
            retList = jedis.hvals(domain);
        }
        catch (Exception ex) {
            logger.error("hvals error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> hkeys(String domain) {
        Jedis jedis = null;
        Set retList = null;
        try {
            jedis = jedisPool.getResource();
            retList = jedis.hkeys(domain);
        }
        catch (Exception ex) {
            logger.error("hkeys error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lenHset(String domain) {
        Jedis jedis = null;
        long retList = 0L;
        try {
            jedis = jedisPool.getResource();
            retList = jedis.hlen(domain);
        }
        catch (Exception ex) {
            logger.error("hkeys error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSortedSet(String key, long score, String value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.zadd(key, (double)score, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("setSortedSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSoredSet(String key, long startScore, long endScore, boolean orderByDesc) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (orderByDesc) {
                Set set = jedis.zrevrangeByScore(key, (double)endScore, (double)startScore);
                return set;
            }
            Set set = jedis.zrangeByScore(key, (double)startScore, (double)endScore);
            return set;
        }
        catch (Exception ex) {
            logger.error("getSoredSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSoredSet(String key, String startScore, String endScore, boolean orderByDesc) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (orderByDesc) {
                Set set = jedis.zrevrangeByScore(key, endScore, startScore);
                return set;
            }
            Set set = jedis.zrangeByScore(key, startScore, endScore);
            return set;
        }
        catch (Exception ex) {
            logger.error("getSoredSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSoredSetASC(String key, String startScore, String endScore, int offset, int count) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Set set = jedis.zrangeByScore(key, startScore, endScore, offset, count);
            return set;
        }
        catch (Exception ex) {
            logger.error("getSoredSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrank(String key, String member) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Long l = jedis.zrank(key, member);
            return l;
        }
        catch (Exception ex) {
            logger.error("getSoredSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countSoredSet(String key, long startScore, long endScore) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Long count = jedis.zcount(key, (double)startScore, (double)endScore);
            long l = count == null ? 0L : count;
            return l;
        }
        catch (Exception ex) {
            logger.error("countSoredSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delSortedSet(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            long count = jedis.zrem(key, new String[]{value});
            boolean bl = count > 0L;
            return bl;
        }
        catch (Exception ex) {
            logger.error("delSortedSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delSet(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            long count = jedis.srem(key, new String[]{value});
            boolean bl = count > 0L;
            return bl;
        }
        catch (Exception ex) {
            logger.error("delSortedSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSoredSetByRange(String key, int startRange, int endRange, boolean orderByDesc) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            if (orderByDesc) {
                Set set = jedis.zrevrange(key, (long)startRange, (long)endRange);
                return set;
            }
            Set set = jedis.zrange(key, (long)startRange, (long)endRange);
            return set;
        }
        catch (Exception ex) {
            logger.error("getSoredSetByRange error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getHmAll(String hmName) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Map map = jedis.hgetAll(hmName);
            return map;
        }
        catch (Exception ex) {
            logger.error("getSoredSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception ex) {
            logger.error("getSoredSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsHashKey(String hmName, String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            boolean bl = jedis.hexists(hmName, key);
            return bl;
        }
        catch (Exception ex) {
            logger.error("getSoredSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getScore(String key, String member) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Double d = jedis.zscore(key, member);
            return d;
        }
        catch (Exception ex) {
            logger.error("getSoredSet error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, String value, int second) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.setex(key, second, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("set error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.set(key, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("set error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, String defaultValue) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            String string = jedis.get(key) == null ? defaultValue : jedis.get(key);
            return string;
        }
        catch (Exception ex) {
            logger.error("get error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setBytes(String key, byte[] value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.set(key.getBytes(), value);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("set error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String key, byte[] defaultValue) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            byte[] byArray = jedis.get(key) == null ? defaultValue : jedis.get(key.getBytes());
            return byArray;
        }
        catch (Exception ex) {
            logger.error("get error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeys(String pattern) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Set set = jedis.keys(pattern);
            return set;
        }
        catch (Exception ex) {
            logger.error("get error.", (Throwable)ex);
            jedisPool.returnBrokenResource(jedis);
        }
        finally {
            jedisPool.returnResource(jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean del(String ... key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.del(key);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.error("del error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incr(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            long l = jedis.incr(key);
            return l;
        }
        catch (Exception ex) {
            logger.error("incr error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decr(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            long l = jedis.decr(key);
            return l;
        }
        catch (Exception ex) {
            logger.error("incr error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void psubscribe(JedisPubSub jedisPubSub, String ... channels) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.psubscribe(jedisPubSub, channels);
        }
        catch (Exception ex) {
            logger.error("incr error.", (Throwable)ex);
            ex.printStackTrace();
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String channel, String message) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            jedis.publish(channel, message);
        }
        catch (Exception ex) {
            logger.error("incr error.", (Throwable)ex);
            this.returnBrokenResource(jedis);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    private void returnBrokenResource(Jedis jedis) {
        try {
            jedis.close();
        }
        catch (Exception e) {
            logger.error("returnBrokenResource error.", (Throwable)e);
        }
    }

    private void returnResource(Jedis jedis) {
        try {
            jedis.close();
        }
        catch (Exception e) {
            logger.error("returnResource error.", (Throwable)e);
        }
    }

    static {
        Properties properties = new Properties();
        InputStream in = RedisUtils.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        try {
            properties.load(in);
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(Integer.parseInt(properties.getProperty("MaxTotal", "1024")));
            config.setMaxIdle(Integer.parseInt(properties.getProperty("MaxIdle", "200")));
            config.setMaxWaitMillis((long)Integer.parseInt(properties.getProperty("MaxWait", "10000")));
            config.setTestOnBorrow(properties.getProperty("Borrow", "true").equals("true"));
            String addr = properties.getProperty("redis.host", "127.0.0.1");
            Integer port = Integer.parseInt(properties.getProperty("redis.port", "6379"));
            logger.info("IP\uff1a{}\uff0cprot\uff1a{}", (Object)addr, (Object)port);
            System.out.println(addr);
            System.out.println(port);
            jedisPool = new JedisPool((GenericObjectPoolConfig)config, addr, port.intValue());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error("Redis\u8fde\u63a5\u6c60\u914d\u7f6e\u9519\u8bef");
            e.printStackTrace();
        }
    }
}

