/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jfinal.kit.JsonKit;
import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static final JsonDelegate delegate;

    public static String toJson(Model<? extends Model<?>> model) {
        return JsonUtils.toJson(CPI.getAttrs(model));
    }

    public static String toJson(Collection<Model<? extends Model<?>>> models) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Model<Model<?>> model : models) {
            list.add(CPI.getAttrs(model));
        }
        return JsonUtils.toJson(list);
    }

    public static String toJson(Record record) {
        return JsonUtils.toJson(record.getColumns());
    }

    public static String toJson(List<Record> records) {
        ArrayList<Map> list = new ArrayList<Map>();
        for (Record record : records) {
            list.add(record.getColumns());
        }
        return JsonUtils.toJson(list);
    }

    public static String toJson(Object object) {
        if (delegate == null) {
            throw new RuntimeException("Jackson, Fastjson and JsonKit are not supported");
        }
        return delegate.toJson(object);
    }

    public static <T> T decode(String jsonString, Class<T> valueType) {
        if (delegate == null) {
            throw new RuntimeException("Jackson, Fastjson and JsonKit are not supported");
        }
        return delegate.decode(jsonString, valueType);
    }

    private static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, true, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static {
        JsonDelegate delegateToUse = null;
        if (JsonUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", JsonUtils.class.getClassLoader())) {
            delegateToUse = new JacksonDelegate();
        } else if (JsonUtils.isPresent("com.alibaba.fastjson.JSONObject", JsonUtils.class.getClassLoader())) {
            delegateToUse = new FastJsonDelegate();
        } else if (JsonUtils.isPresent("com.jfinal.kit.JsonKit", JsonUtils.class.getClassLoader())) {
            delegateToUse = new JsonKitDelegate();
        }
        delegate = delegateToUse;
    }

    private static class JsonKitDelegate
    implements JsonDelegate {
        private JsonKitDelegate() {
        }

        @Override
        public String toJson(Object object) {
            return JsonKit.toJson((Object)object);
        }

        @Override
        public <T> T decode(String jsonString, Class<T> valueType) {
            throw new RuntimeException("Jackson, Fastjson are not supported~");
        }
    }

    private static class FastJsonDelegate
    implements JsonDelegate {
        private FastJsonDelegate() {
        }

        @Override
        public String toJson(Object object) {
            return JSONObject.toJSONString((Object)object);
        }

        @Override
        public <T> T decode(String jsonString, Class<T> valueType) {
            return (T)JSON.parseObject((String)jsonString, valueType);
        }
    }

    private static class JacksonDelegate
    implements JsonDelegate {
        private JacksonDelegate() {
        }

        @Override
        public String toJson(Object object) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public <T> T decode(String jsonString, Class<T> valueType) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (T)objectMapper.readValue(jsonString, valueType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface JsonDelegate {
        public String toJson(Object var1);

        public <T> T decode(String var1, Class<T> var2);
    }
}

