/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.roseboy.framework.util.DateUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelUtils {
    public static File exportXls(String head, List<String> titles, List<String> fields, List<Map<String, Object>> records) {
        HSSFCell cell;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        workbook.setSheetName(0, head);
        int index = 0;
        HSSFRow row = sheet.createRow(index);
        for (int i = 0; i < titles.size(); ++i) {
            cell = row.createCell(i);
            cell.setCellValue(titles.get(i));
            cell.setCellStyle(ExcelUtils.getTitleStyle(workbook));
        }
        ++index;
        for (Map<String, Object> record : records) {
            row = sheet.createRow(index);
            for (int i = 0; i < fields.size(); ++i) {
                String field = fields.get(i);
                Object value = record.get(field);
                value = value == null ? "" : value;
                String clsname = value.getClass().getSimpleName();
                cell = row.createCell(i);
                if ("String".equals(clsname)) {
                    cell.setCellValue(value.toString());
                    continue;
                }
                if ("Double".equals(clsname)) {
                    cell.setCellValue(Double.parseDouble(value.toString()));
                    continue;
                }
                if ("Timestamp".equals(clsname)) {
                    try {
                        Date date = DateUtils.parseDate(value.toString(), "yyyy-MM-dd HH:mm:ss.0");
                        cell.setCellValue(DateUtils.parseDate(date, "yyyy-MM-dd HH:mm:ss"));
                    }
                    catch (ParseException e) {
                        cell.setCellValue(value.toString());
                    }
                    continue;
                }
                if ("Integer".equals(clsname)) {
                    cell.setCellValue((double)Integer.parseInt(value.toString()));
                    continue;
                }
                if ("Long".equals(clsname)) {
                    cell.setCellValue((double)Long.parseLong(value.toString()));
                    continue;
                }
                if ("Boolean".equals(clsname)) {
                    cell.setCellValue(Boolean.parseBoolean(value.toString()));
                    continue;
                }
                if ("BigDecimal".equals(clsname)) {
                    cell.setCellValue(value.toString());
                    continue;
                }
                cell.setCellValue(value.toString());
            }
            ++index;
        }
        String uploadPath = ExcelUtils.class.getResource("/").getPath() + "../../upload/xls_temp/";
        File uploadFile = new File(uploadPath);
        if (!uploadFile.exists()) {
            uploadFile.mkdirs();
        } else {
            String[] paths = uploadFile.list();
            if (paths != null && paths.length >= 30) {
                for (String p : paths) {
                    File file = new File(uploadFile, p);
                    file.delete();
                }
            }
        }
        String fname = uploadPath + head + "-" + DateUtils.parseDate(new Date(), "yyyyMMddhhmmss") + ".xls";
        try {
            FileOutputStream fOut = new FileOutputStream(fname);
            workbook.write((OutputStream)fOut);
            fOut.flush();
            fOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File f = new File(fname);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    private static HSSFCellStyle getTitleStyle(HSSFWorkbook workbook) {
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        HSSFFont font = workbook.createFont();
        font.setBoldweight((short)700);
        font.setFontHeightInPoints((short)11);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static List<Map<String, Object>> readerExcel(File xlsFile) {
        return ExcelUtils.readerExcel(xlsFile, 0);
    }

    public static List<Map<String, Object>> readerExcel(File xlsFile, int line) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            long columnNum = 0L;
            FileInputStream inp = new FileInputStream(xlsFile);
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)inp);
            Sheet sheet = wb.getSheetAt(0);
            if (sheet.getRow(0) != null) {
                columnNum = sheet.getRow(0).getLastCellNum() - sheet.getRow(0).getFirstCellNum();
            }
            ArrayList<String> titles = new ArrayList<String>();
            if (columnNum > 0L) {
                for (Row row : sheet) {
                    LinkedHashMap map = new LinkedHashMap();
                    int i = 0;
                    while ((long)i < columnNum) {
                        Cell cell = row.getCell(i, Row.CREATE_NULL_AS_BLANK);
                        if (row.getRowNum() == line) {
                            titles.add(cell.getStringCellValue());
                        } else if (row.getRowNum() > line) {
                            Object value = ExcelUtils.getCellValue(cell);
                            map.put(titles.get(i), value);
                        }
                        ++i;
                    }
                    if (map.size() <= 0) continue;
                    list.add(map);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static Object getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                DecimalFormat df = new DecimalFormat("0.00");
                String v = df.format(cell.getNumericCellValue());
                return new BigDecimal(v);
            }
            case 1: {
                return cell.getStringCellValue().trim();
            }
            case 5: {
                return "ERROR";
            }
        }
        return "";
    }

    public static void main(String[] args) {
        File file = new File("C:\\Users\\admin\\Desktop\\CEA\u5f97\u520620170519110024.xls");
        List<Map<String, Object>> list = ExcelUtils.readerExcel(file, 0);
        for (Map<String, Object> map : list) {
            System.out.println(map);
        }
    }
}

