/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import net.roseboy.framework.core.KModel;
import net.roseboy.framework.core.KPage;
import net.roseboy.framework.util.ClassKits;
import net.roseboy.framework.util.ExceptionUtils;

public abstract class KService<M extends KModel<M>> {
    protected M dao = null;

    public KService() {
        Class modelClass = null;
        Type t = ClassKits.getUsefulClass(this.getClass()).getGenericSuperclass();
        if (t instanceof ParameterizedType) {
            Type[] p = ((ParameterizedType)t).getActualTypeArguments();
            modelClass = (Class)p[0];
        }
        if (modelClass == null) {
            ExceptionUtils.ThrowProjectException("can not get parameterizedType in KService");
        }
        this.dao = (KModel)((KModel)((Object)ClassKits.newInstance(modelClass))).dao();
    }

    public M getDao() {
        return this.dao;
    }

    public M findById(Object id) {
        return (M)((Object)((KModel)this.dao.findById(id)));
    }

    public List<M> findAll() {
        return ((KModel)((Object)this.dao)).findAll();
    }

    public boolean deleteById(Object id) {
        return this.dao.deleteById(id);
    }

    public boolean deleteByIds(String[] ids) {
        int i = 0;
        for (String id : ids) {
            if (!this.dao.deleteById((Object)id)) continue;
            ++i;
        }
        return ids.length == i;
    }

    public int deleteByProperty(String property, Object value) {
        return ((KModel)((Object)this.dao)).deleteByProperty(property, value);
    }

    public boolean delete(M model) {
        return model.delete();
    }

    public boolean save(M model) {
        return model.save();
    }

    public boolean saveOrUpdate(M model) {
        return ((KModel)((Object)model)).saveOrUpdate();
    }

    public boolean update(M model) {
        return model.update();
    }

    public M findOneByProperty(String property, Object value) {
        KPage kpage = new KPage();
        kpage.addWhere("eq." + property, value);
        return (M)((Object)((KModel)((Object)((KModel)((Object)this.dao)).findFirst(kpage))));
    }

    public List<M> findByProperty(String property, Object value) {
        KPage kpage = new KPage();
        kpage.addWhere("eq." + property, value);
        return ((KModel)((Object)this.dao)).find(kpage);
    }

    public KPage<M> findPage(KPage<M> kpage) {
        return ((KModel)((Object)this.dao)).findPage(kpage);
    }

    public List<M> find(KPage<M> kpage) {
        return ((KModel)((Object)this.dao)).find(kpage);
    }

    public boolean SAVE(M model) {
        return ((KModel)((Object)model)).saveOrUpdate2();
    }
}

