/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.core;

import com.alibaba.druid.util.StringUtils;
import com.jfinal.core.Controller;
import com.jfinal.json.Jackson;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.roseboy.framework.core.JFinalUtils;
import net.roseboy.framework.core.KPage;
import net.roseboy.framework.util.ExcelUtils;
import net.roseboy.framework.util.ExceptionUtils;
import net.roseboy.framework.util.RedisUtils;
import net.roseboy.framework.util.TypeConverter;

public abstract class KController
extends Controller {
    public KController() {
        JFinalUtils.AutoBindService((Object)this);
    }

    public <T> KPage<T> getKPage() {
        String[] orders;
        KPage kpage = new KPage();
        int page = this.getParaToInt("page", 1);
        page = page < 1 ? 1 : page;
        int rows = this.getParaToInt("rows", 30);
        rows = rows < 1 ? 1 : rows;
        LinkedHashMap<String, Object> whereMap = new LinkedHashMap<String, Object>();
        Set nameSet = this.getParaMap().keySet();
        for (String name : nameSet) {
            String[] names = name.split("\\.");
            String value = this.getPara(name, "");
            if (names.length != 4 || !"where".equals(names[0].toLowerCase()) || value.length() <= 0) continue;
            if ("S".equals(names[1].toUpperCase())) {
                whereMap.put(names[2] + "." + names[3], this.getPara(name));
                continue;
            }
            if ("I".equals(names[1].toUpperCase())) {
                whereMap.put(names[2] + "." + names[3], this.getParaToInt(name));
                continue;
            }
            if ("L".equals(names[1].toUpperCase())) {
                whereMap.put(names[2] + "." + names[3], this.getParaToLong(name));
                continue;
            }
            if ("N".equals(names[1].toUpperCase())) {
                whereMap.put(names[2] + "." + names[3], Double.parseDouble(this.getPara(name, "0")));
                continue;
            }
            if ("D".equals(names[1].toUpperCase())) {
                whereMap.put(names[2] + "." + names[3], this.getParaToDate(name));
                continue;
            }
            if ("B".equals(names[1].toUpperCase())) {
                whereMap.put(names[2] + "." + names[3], this.getParaToBoolean(name));
                continue;
            }
            if ("T".equals(names[1].toUpperCase())) {
                whereMap.put(names[2] + "." + names[3], new BigDecimal(this.getPara(name, "0")));
                continue;
            }
            whereMap.put(names[2] + "." + names[3], this.getPara(name));
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        String[] sorts = this.getPara("sort", "").split(",");
        if (sorts.length == (orders = this.getPara("order", "").split(",")).length) {
            for (int i = 0; i < sorts.length; ++i) {
                if (sorts[i] == null || sorts[i].isEmpty()) continue;
                orderMap.put(sorts[i], orders[i]);
            }
        }
        kpage.setPageNo(page);
        kpage.setPageSize(rows);
        kpage.setWhere(whereMap);
        kpage.setOrder(orderMap);
        return kpage;
    }

    public Long[] getParaValuesToLong(String name) {
        String[] values = this.getRequest().getParameterValues(name);
        if (values == null) {
            return null;
        }
        Long[] result = new Long[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Long.parseLong(values[i]);
        }
        return result;
    }

    public void renderXls(String head, List<String> titles, List<String> fields, List<?> records) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (records != null && records.size() > 0) {
            if (records.get(0) instanceof Record) {
                for (Object record : records) {
                    list.add(((Record)record).getColumns());
                }
            } else if (records.get(0) instanceof Model) {
                for (Object obj : records) {
                    Record record = ((Model)obj).toRecord();
                    list.add(record.getColumns());
                }
            } else if (records.get(0) instanceof Map) {
                for (Object obj : records) {
                    list.add((Map)obj);
                }
            } else {
                ExceptionUtils.ThrowProjectException("\u8868\u683c\u6570\u636e\u6709\u8bef");
            }
        }
        File xlsFile = ExcelUtils.exportXls(head, titles, fields, list);
        this.renderFile(xlsFile);
    }

    public void renderXls(String head, String[] titles, String[] fields, List<?> records) {
        this.renderXls(head, Arrays.asList(titles), Arrays.asList(fields), records);
    }

    public void renderXls(String head, List<String> titles, List<?> records) {
        this.renderXls(head, titles, titles, records);
    }

    public void renderXls(String head, String[] titles, List<?> records) {
        this.renderXls(head, Arrays.asList(titles), records);
    }

    public void renderXls(String head, Map<String, String> fields_titles, List<?> records) {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> titles = new ArrayList<String>();
        for (Map.Entry<String, String> entry : fields_titles.entrySet()) {
            fields.add(entry.getKey());
            titles.add(entry.getValue());
        }
        this.renderXls(head, titles, fields, records);
    }

    public void renderJson(Object obj) {
        super.renderJson(Jackson.getJson().toJson(obj));
    }

    private static <T> T createInstance(Class<T> objClass) {
        try {
            return objClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getForm(Class<T> modelClass) {
        String modelName = modelClass.getSimpleName();
        modelName = StrKit.firstCharToLowerCase((String)modelName);
        T temp = KController.createInstance(modelClass);
        if (!(temp instanceof Model)) {
            throw new IllegalArgumentException("getModel only support class of Model, using getBean for other class.");
        }
        Model model = (Model)temp;
        Table table = TableMapping.me().getTable(model.getClass());
        if (table == null) {
            throw new ActiveRecordException("The Table mapping of model: " + modelClass.getName() + " not exists or the ActiveRecordPlugin not start.");
        }
        String modelNameAndDot = StrKit.notBlank((String)modelName) ? modelName + "." : null;
        Map parasMap = this.getRequest().getParameterMap();
        for (Map.Entry entry : parasMap.entrySet()) {
            String attrName;
            String paraName = (String)entry.getKey();
            if (modelNameAndDot != null) {
                if (!paraName.startsWith(modelNameAndDot)) continue;
                attrName = paraName.substring(modelNameAndDot.length());
                attrName = JFinalUtils.toDbName(attrName);
                System.out.println(attrName);
            } else {
                attrName = paraName;
            }
            Class colType = table.getColumnType(attrName);
            if (colType == null) {
                throw new ActiveRecordException("The model attribute " + attrName + " is not exists.");
            }
            try {
                String[] paraValueArray = (String[])entry.getValue();
                String paraValue = paraValueArray != null && paraValueArray.length > 0 ? paraValueArray[0] : null;
                Object value = paraValue != null ? TypeConverter.convert(colType, paraValue) : null;
                model.set(attrName, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not convert parameter: " + paraName, e);
            }
        }
        return (T)model;
    }

    public String getToken() {
        String tokenStr = this.getRequest().getHeader("AppToken");
        if (StringUtils.isEmpty((String)tokenStr)) {
            tokenStr = this.getRequest().getParameter("token");
        }
        return tokenStr;
    }

    public String getOpenId() {
        String openId = RedisUtils.getInstance().get("ddbj_token:" + this.getToken(), "");
        return openId;
    }
}

