/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.framework.core;

import com.jfinal.aop.Duang;
import com.jfinal.config.Routes;
import com.jfinal.core.Controller;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.roseboy.framework.annotation.ControllerBind;
import net.roseboy.framework.annotation.Service;
import net.roseboy.framework.annotation.TableBind;
import net.roseboy.framework.util.ClassSearcher;
import net.roseboy.framework.util.ExceptionUtils;
import net.roseboy.framework.util.Log;

public class JFinalUtils {
    private static Map<String, String> MODELMAPPER = new HashMap<String, String>();
    private static Map<String, Object> serviceMap = new HashMap<String, Object>();

    public static void addModel(String name, String cksName) {
        if (!MODELMAPPER.containsKey(name)) {
            MODELMAPPER.put(name, cksName);
        } else {
            ExceptionUtils.ThrowProjectException("Model\u540d\u79f0:\"" + name + "\"\u5df2\u7ecf\u5b58\u5728");
        }
    }

    public static String getClassName(String name) {
        return MODELMAPPER.get(name);
    }

    public static Object getService(String name) {
        return serviceMap.get(name);
    }

    public static Table getTable(Class<? extends Model> cls) {
        Table table = TableMapping.me().getTable(cls);
        if (table == null) {
            ExceptionUtils.ThrowProjectException("\u83b7\u53d6\u8868\u5931\u8d25");
        }
        return table;
    }

    public static Model<?> getObjByModelName(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(JFinalUtils.getClassName(name));
        Model obj = (Model)clazz.newInstance();
        return obj;
    }

    public static void AutoBindController(Routes r) {
        List controllerClasses = ClassSearcher.of(Controller.class).search();
        ControllerBind cb = null;
        for (Class c : controllerClasses) {
            if (!c.isAnnotationPresent(ControllerBind.class)) continue;
            cb = c.getAnnotation(ControllerBind.class);
            if ("".equals(cb.viewPath())) {
                r.add(cb.controllerKey(), c);
            } else {
                r.add(cb.controllerKey(), c, cb.viewPath());
            }
            Log.info("ControllerBinding: " + cb.controllerKey() + "==>" + c.getName());
        }
    }

    public static void AutoBindTable(ActiveRecordPlugin arpDb) {
        List modelClasses = ClassSearcher.of(Model.class).search();
        TableBind tb = null;
        for (Class c : modelClasses) {
            if (!c.isAnnotationPresent(TableBind.class)) continue;
            tb = c.getAnnotation(TableBind.class);
            if ("".equals(tb.primaryKey())) {
                arpDb.addMapping(tb.tabName(), c);
            } else {
                arpDb.addMapping(tb.tabName(), tb.primaryKey(), c);
            }
            String modelName = tb.name();
            if ("".equals(modelName)) {
                modelName = c.getSimpleName();
            }
            modelName = modelName.toLowerCase();
            JFinalUtils.addModel(modelName, c.getName());
            Log.info("TableBinding: " + modelName + "==>" + c.getName() + "==>" + tb.tabName());
        }
    }

    public static void AutoBindService() {
        List allClasses = ClassSearcher.of(Object.class).search();
        for (Class clazz : allClasses) {
            if (!clazz.isAnnotationPresent(Service.class)) continue;
            try {
                serviceMap.put(clazz.getName(), Duang.duang(clazz.newInstance().getClass()));
                Log.info("Service: " + clazz.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : serviceMap.entrySet()) {
            Field[] fields;
            for (Field f : fields = entry.getValue().getClass().getSuperclass().getDeclaredFields()) {
                Object service = JFinalUtils.getService(f.getType().getName());
                if (service == null) continue;
                try {
                    f.setAccessible(true);
                    f.set(entry.getValue(), service);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void AutoBindService(Object obj) {
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Object service = JFinalUtils.getService(field.getType().getName());
            if (service == null) continue;
            try {
                field.setAccessible(true);
                field.set(obj, service);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String toJavaName(String n, String q) {
        n = n.toLowerCase();
        String[] ss = n.split("_");
        n = "";
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i];
            n = n + s.substring(0, 1).toUpperCase() + s.substring(1);
        }
        n = StrKit.isBlank((String)q) ? n.substring(0, 1).toLowerCase() + n.substring(1) : q + n;
        return n;
    }

    public static String toDbName(String n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n.length(); ++i) {
            if (Character.isUpperCase(n.charAt(i))) {
                sb.append("_").append(Character.toLowerCase(n.charAt(i)));
                continue;
            }
            sb.append(n.charAt(i));
        }
        return sb.toString();
    }
}

