/*
 * Decompiled with CFR 0.152.
 */
package jfinal.plugin.shiro;

import com.jfinal.config.Routes;
import com.jfinal.core.ActionKey;
import com.jfinal.core.Controller;
import com.jfinal.plugin.IPlugin;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jfinal.plugin.shiro.AuthenticatedAuthzHandler;
import jfinal.plugin.shiro.AuthzHandler;
import jfinal.plugin.shiro.ClearShiro;
import jfinal.plugin.shiro.CompositeAuthzHandler;
import jfinal.plugin.shiro.GuestAuthzHandler;
import jfinal.plugin.shiro.PermissionAuthzHandler;
import jfinal.plugin.shiro.RoleAuthzHandler;
import jfinal.plugin.shiro.ShiroKit;
import jfinal.plugin.shiro.UserAuthzHandler;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;

public class ShiroPlugin
implements IPlugin {
    private String successUrl = "/";
    private String loginUrl = "";
    private String unauthorizedUrl = "";
    private final String SLASH = "/";
    private static final Class<? extends Annotation>[] AUTHZ_ANNOTATION_CLASSES = new Class[]{RequiresPermissions.class, RequiresRoles.class, RequiresUser.class, RequiresGuest.class, RequiresAuthentication.class};
    private final Routes routes;

    public ShiroPlugin(Routes routes) {
        this.routes = routes;
    }

    public boolean stop() {
        return true;
    }

    public boolean start() {
        Set<String> excludedMethodName = this.buildExcludedMethodName();
        ConcurrentHashMap<String, AuthzHandler> authzMaps = new ConcurrentHashMap<String, AuthzHandler>();
        for (Routes.Route route : this.routes.getRouteItemList()) {
            Method[] methods;
            Class controllerClass = route.getControllerClass();
            String controllerKey = route.getControllerKey();
            List<Annotation> controllerAnnotations = this.getAuthzAnnotations(controllerClass);
            for (Method method : methods = controllerClass.getMethods()) {
                List<Annotation> methodAnnotations;
                AuthzHandler authzHandler;
                if (excludedMethodName.contains(method.getName()) || method.getParameterTypes().length != 0 || this.isClearShiroAnnotationPresent(method) || (authzHandler = this.createAuthzHandler(controllerAnnotations, methodAnnotations = this.getAuthzAnnotations(method))) == null) continue;
                String actionKey = this.createActionKey(controllerClass, method, controllerKey);
                authzMaps.put(actionKey, authzHandler);
            }
        }
        ShiroKit.init(authzMaps);
        ShiroKit.setLoginUrl(this.loginUrl);
        ShiroKit.setSuccessUrl(this.successUrl);
        ShiroKit.setUnauthorizedUrl(this.unauthorizedUrl);
        return true;
    }

    private Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>();
        for (Method m : methods = Controller.class.getMethods()) {
            if (m.getParameterTypes().length != 0) continue;
            excludedMethodName.add(m.getName());
        }
        return excludedMethodName;
    }

    private AuthzHandler createAuthzHandler(List<Annotation> controllerAnnotations, List<Annotation> methodAnnotations) {
        if (controllerAnnotations.size() == 0 && methodAnnotations.size() == 0) {
            return null;
        }
        ArrayList<AuthzHandler> authzHandlers = new ArrayList<AuthzHandler>(5);
        for (int index = 0; index < 5; ++index) {
            authzHandlers.add(null);
        }
        this.scanAnnotation(authzHandlers, controllerAnnotations);
        this.scanAnnotation(authzHandlers, methodAnnotations);
        ArrayList<AuthzHandler> finalAuthzHandlers = new ArrayList<AuthzHandler>();
        for (AuthzHandler a : authzHandlers) {
            if (a == null) continue;
            finalAuthzHandlers.add(a);
        }
        authzHandlers = null;
        if (finalAuthzHandlers.size() > 1) {
            return new CompositeAuthzHandler(finalAuthzHandlers);
        }
        return (AuthzHandler)finalAuthzHandlers.get(0);
    }

    private void scanAnnotation(List<AuthzHandler> authzArray, List<Annotation> annotations) {
        if (null == annotations || 0 == annotations.size()) {
            return;
        }
        for (Annotation a : annotations) {
            if (a instanceof RequiresRoles) {
                authzArray.set(0, new RoleAuthzHandler(a));
                continue;
            }
            if (a instanceof RequiresPermissions) {
                authzArray.set(1, new PermissionAuthzHandler(a));
                continue;
            }
            if (a instanceof RequiresAuthentication) {
                authzArray.set(2, AuthenticatedAuthzHandler.me());
                continue;
            }
            if (a instanceof RequiresUser) {
                authzArray.set(3, UserAuthzHandler.me());
                continue;
            }
            if (!(a instanceof RequiresGuest)) continue;
            authzArray.set(4, GuestAuthzHandler.me());
        }
    }

    private String createActionKey(Class<? extends Controller> controllerClass, Method method, String controllerKey) {
        String methodName = method.getName();
        String actionKey = "";
        ActionKey ak = method.getAnnotation(ActionKey.class);
        if (ak != null) {
            actionKey = ak.value().trim();
            if ("".equals(actionKey)) {
                throw new IllegalArgumentException(controllerClass.getName() + "." + methodName + "(): The argument of ActionKey can not be blank.");
            }
            if (!actionKey.startsWith("/")) {
                actionKey = "/" + actionKey;
            }
        } else {
            actionKey = methodName.equals("index") ? controllerKey : (controllerKey.equals("/") ? "/" + methodName : controllerKey + "/" + methodName);
        }
        return actionKey;
    }

    private List<Annotation> getAuthzAnnotations(Method method) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Class<? extends Annotation> annClass : AUTHZ_ANNOTATION_CLASSES) {
            Annotation a = method.getAnnotation(annClass);
            if (a == null) continue;
            annotations.add(a);
        }
        return annotations;
    }

    private List<Annotation> getAuthzAnnotations(Class<? extends Controller> targetClass) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Class<? extends Annotation> annClass : AUTHZ_ANNOTATION_CLASSES) {
            Annotation a = targetClass.getAnnotation(annClass);
            if (a == null) continue;
            annotations.add(a);
        }
        return annotations;
    }

    private boolean isClearShiroAnnotationPresent(Method method) {
        ClearShiro a = method.getAnnotation(ClearShiro.class);
        return a != null;
    }

    public final void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public final void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public final void setUnauthorizedUrl(String unauthorizedUrl) {
        this.unauthorizedUrl = unauthorizedUrl;
    }
}

