/*
 * Decompiled with CFR 0.152.
 */
package jfinal.plugin.quartz;

import com.jfinal.plugin.IPlugin;
import java.util.ArrayList;
import java.util.List;
import jfinal.plugin.quartz.Scheduled;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzPlugin
implements IPlugin {
    private Logger logger = Logger.getLogger(QuartzPlugin.class);
    private static SchedulerFactory sf = new StdSchedulerFactory();
    private Class[] objects;
    private List<Scheduler> Schedulers = new ArrayList<Scheduler>();
    private boolean isStarted = false;

    public QuartzPlugin(Class ... objects) {
        this.objects = objects;
    }

    public boolean start() {
        if (this.isStarted) {
            return true;
        }
        if (this.objects != null) {
            for (Class clazz : this.objects) {
                Scheduled scheduled = clazz.getAnnotation(Scheduled.class);
                try {
                    Class<?> clazz2;
                    if (scheduled == null) {
                        this.logger.warn((Object)"JOB \u6ca1\u6709\u6ce8\u89e3\u3002");
                        continue;
                    }
                    Scheduler sched = sf.getScheduler();
                    String jobClassName = clazz.getName();
                    String jobCronExp = scheduled.cron();
                    int fixedDelay = scheduled.fixedDelay();
                    boolean enable = scheduled.enable();
                    if (!enable) continue;
                    try {
                        clazz2 = Class.forName(jobClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    CronTrigger cronTrigger = null;
                    Trigger trigger = null;
                    JobDetail jobDetail = JobBuilder.newJob(clazz2).withIdentity(jobClassName, jobClassName).build();
                    if (fixedDelay > 0) {
                        int second = fixedDelay / 1000;
                        trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)second)).startNow().build();
                        sched.scheduleJob(jobDetail, trigger);
                        sched.start();
                    }
                    if (jobCronExp == null || "".equals(jobCronExp)) continue;
                    cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobCronExp)).startNow().build();
                    sched.scheduleJob(jobDetail, (Trigger)cronTrigger);
                    sched.start();
                }
                catch (SchedulerException e) {
                    new RuntimeException(e);
                }
            }
        }
        this.isStarted = true;
        return true;
    }

    public boolean stop() {
        for (Scheduler scheduler : this.Schedulers) {
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                this.logger.error((Object)"shutdown error", (Throwable)e);
            }
        }
        this.isStarted = false;
        return true;
    }
}

