/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.woof;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.configuration.ConfigurationContext;
import net.officefloor.configuration.impl.classloader.ClassLoaderConfigurationContext;
import net.officefloor.eclipse.configurer.ClassBuilder;
import net.officefloor.eclipse.configurer.FlagBuilder;
import net.officefloor.eclipse.configurer.ListBuilder;
import net.officefloor.eclipse.configurer.ResourceBuilder;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedModelVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.woof.WoofEditor;
import net.officefloor.eclipse.woof.WoofTemplateOutputItem;
import net.officefloor.frame.api.source.ResourceSource;
import net.officefloor.model.ConnectionModel;
import net.officefloor.plugin.managedfunction.clazz.FlowInterface;
import net.officefloor.web.template.build.WebTemplate;
import net.officefloor.web.template.build.WebTemplateArchitectEmployer;
import net.officefloor.web.template.type.WebTemplateLoader;
import net.officefloor.web.template.type.WebTemplateType;
import net.officefloor.woof.model.woof.WoofChangeIssues;
import net.officefloor.woof.model.woof.WoofChanges;
import net.officefloor.woof.model.woof.WoofExceptionToWoofTemplateModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationToWoofTemplateModel;
import net.officefloor.woof.model.woof.WoofHttpInputToWoofTemplateModel;
import net.officefloor.woof.model.woof.WoofModel;
import net.officefloor.woof.model.woof.WoofSectionOutputToWoofTemplateModel;
import net.officefloor.woof.model.woof.WoofSecurityOutputToWoofTemplateModel;
import net.officefloor.woof.model.woof.WoofTemplateChangeContext;
import net.officefloor.woof.model.woof.WoofTemplateChangeContextImpl;
import net.officefloor.woof.model.woof.WoofTemplateExtension;
import net.officefloor.woof.model.woof.WoofTemplateLinkModel;
import net.officefloor.woof.model.woof.WoofTemplateModel;
import net.officefloor.woof.model.woof.WoofTemplateOutputToWoofTemplateModel;
import net.officefloor.woof.model.woof.WoofTemplateRenderHttpMethodModel;
import net.officefloor.woof.model.woof.WoofTemplateToSuperWoofTemplateModel;
import net.officefloor.woof.template.WoofTemplateExtensionLoaderUtil;

public class WoofTemplateItem
extends AbstractConfigurableItem<WoofModel, WoofModel.WoofEvent, WoofChanges, WoofTemplateModel, WoofTemplateModel.WoofTemplateEvent, WoofTemplateItem> {
    private String applicationPath;
    private String location;
    private String logicClass;
    private WebTemplateType type;
    private Map<String, String> outputNameMapping;
    private String redirectValuesFunction;
    private boolean isSecure;
    private List<LinkSecure> links = new LinkedList<LinkSecure>();
    private String contentType;
    private String charset;
    private String linkSeparatorCharacter;
    private String renderHttpMethods;

    public static void main(String[] args) {
        WoofEditor.launchConfigurer(new WoofTemplateItem(), model -> {
            model.setApplicationPath("/path");
            model.setIsTemplateSecure(true);
            model.addLink(new WoofTemplateLinkModel("link", false));
            model.addLink(new WoofTemplateLinkModel("secure", true));
            model.setTemplateLocation("net/officefloor/eclipse/woof/mock/MockTemplate.html");
            model.setTemplateClassName(MockLogic.class.getName());
            model.setRedirectValuesFunction("redirect");
            model.setTemplateContentType("application/text");
            model.setTemplateCharset("UTF-8");
            model.setLinkSeparatorCharacter("+");
            model.addRenderHttpMethod(new WoofTemplateRenderHttpMethodModel("POST"));
            model.addRenderHttpMethod(new WoofTemplateRenderHttpMethodModel("PUT"));
        });
    }

    private Map<String, Boolean> getLinksSecure(WoofTemplateItem item) {
        HashMap<String, Boolean> links = new HashMap<String, Boolean>();
        for (LinkSecure link : item.links) {
            if (link.linkName == null || link.linkName.trim().length() <= 0) continue;
            links.put(link.linkName.trim(), link.isSecure);
        }
        return links;
    }

    private WoofTemplateChangeContext getWoofTemplateChangeContext(AbstractItem.ConfigurableContext<WoofModel, WoofChanges> context) throws Exception {
        ClassLoader classLoader = context.getOsgiBridge().getClassLoader();
        ClassLoaderConfigurationContext configurationContext = new ClassLoaderConfigurationContext(classLoader, null);
        WoofChangeIssues issues = WoofTemplateExtensionLoaderUtil.getWoofChangeIssues();
        WoofTemplateChangeContextImpl changeContext = new WoofTemplateChangeContextImpl(false, classLoader, (ConfigurationContext)configurationContext, issues, new ResourceSource[0]);
        return changeContext;
    }

    public WoofTemplateModel prototype() {
        return new WoofTemplateModel("Template", null, null, null, null, null, null, false);
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getWoofTemplates(), (Enum[])new WoofModel.WoofEvent[]{WoofModel.WoofEvent.ADD_WOOF_TEMPLATE, WoofModel.WoofEvent.REMOVE_WOOF_TEMPLATE});
    }

    public Pane visual(WoofTemplateModel model, AdaptedModelVisualFactoryContext<WoofTemplateModel> context) {
        VBox container = new VBox();
        HBox heading = (HBox)context.addNode((Pane)container, (Node)new HBox());
        context.addNode((Pane)heading, context.connector(DefaultConnectors.FLOW, new Class[]{WoofHttpContinuationToWoofTemplateModel.class, WoofHttpInputToWoofTemplateModel.class, WoofTemplateOutputToWoofTemplateModel.class, WoofSecurityOutputToWoofTemplateModel.class, WoofSectionOutputToWoofTemplateModel.class, WoofExceptionToWoofTemplateModel.class}).target(new Class[]{WoofTemplateToSuperWoofTemplateModel.class}).getNode());
        context.label((Pane)heading);
        context.addNode((Pane)heading, context.connector(DefaultConnectors.DERIVE, new Class[0]).source(new Class[]{WoofTemplateToSuperWoofTemplateModel.class}).getNode());
        context.addNode((Pane)container, (Node)((VBox)context.childGroup(WoofTemplateOutputItem.class.getSimpleName(), (Pane)new VBox())));
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getApplicationPath(), (Enum[])new WoofTemplateModel.WoofTemplateEvent[]{WoofTemplateModel.WoofTemplateEvent.CHANGE_APPLICATION_PATH});
    }

    public void loadToParent(WoofModel parentModel, WoofTemplateModel itemModel) {
        parentModel.addWoofTemplate(itemModel);
    }

    protected WoofTemplateItem item(WoofTemplateModel model) {
        WoofTemplateItem item = new WoofTemplateItem();
        if (model != null) {
            item.applicationPath = model.getApplicationPath();
            item.isSecure = model.getIsTemplateSecure();
            item.location = model.getTemplateLocation();
            item.logicClass = model.getTemplateClassName();
            item.redirectValuesFunction = model.getRedirectValuesFunction();
            item.contentType = model.getTemplateContentType();
            item.charset = model.getTemplateCharset();
            item.linkSeparatorCharacter = model.getLinkSeparatorCharacter();
            item.renderHttpMethods = this.translateToCommaSeparateList(model.getRenderHttpMethods(), method -> method.getWoofTemplateRenderHttpMethodName());
            for (WoofTemplateLinkModel link : model.getLinks()) {
                item.links.add(new LinkSecure(link));
            }
        }
        return item;
    }

    protected void loadStyles(List<AbstractItem.IdeStyle> styles) {
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 50.0%, blue, dodgerblue)"));
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this, ".${model} .label").rule("-fx-text-fill", "lightcyan"));
    }

    protected void connections(List<AbstractItem.IdeConnectionTarget<? extends ConnectionModel, ?, ?>> connections) {
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofTemplateToSuperWoofTemplateModel.class).connectOne(s -> s.getSuperWoofTemplate(), c -> c.getChildWoofTemplate(), (Enum[])new WoofTemplateModel.WoofTemplateEvent[]{WoofTemplateModel.WoofTemplateEvent.CHANGE_SUPER_WOOF_TEMPLATE}).to(WoofTemplateModel.class).many(t -> t.getChildWoofTemplates(), c -> c.getSuperWoofTemplate(), new Enum[]{WoofTemplateModel.WoofTemplateEvent.ADD_CHILD_WOOF_TEMPLATE, WoofTemplateModel.WoofTemplateEvent.REMOVE_CHILD_WOOF_TEMPLATE}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkTemplateToSuperTemplate(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeTemplateToSuperTemplate((WoofTemplateToSuperWoofTemplateModel)ctx.getModel()))));
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("Template");
            ((TextBuilder)((TextBuilder)builder.text("Path").init(item -> item.applicationPath)).validate(ValueValidator.notEmptyString((String)"Must provide path"))).setValue((item, value) -> {
                String string = item.applicationPath = value;
            });
            ((ResourceBuilder)((ResourceBuilder)builder.resource("Location").init(item -> item.location)).validate(ValueValidator.notEmptyString((String)"Must provide location"))).setValue((item, value) -> {
                String string = item.location = value;
            });
            ((ClassBuilder)builder.clazz("Logic").init(item -> item.logicClass)).setValue((item, value) -> {
                String string = item.logicClass = value;
            });
            ((TextBuilder)((TextBuilder)builder.text("Redirect values method").init(item -> item.redirectValuesFunction)).validate(ctx -> {
                String logicClassName = ((WoofTemplateItem)((Object)((Object)((Object)ctx.getModel())))).logicClass;
                if (logicClassName == null || logicClassName.trim().length() == 0) {
                    return;
                }
                String redirectMethodName = (String)ctx.getValue().getValue();
                if (redirectMethodName == null || redirectMethodName.trim().length() == 0) {
                    return;
                }
                Class logicClass = this.getConfigurableContext().getOsgiBridge().loadClass(((WoofTemplateItem)((Object)((Object)((Object)ctx.getModel())))).logicClass, Object.class);
                Method[] methodArray = logicClass.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (redirectMethodName.equals(method.getName())) {
                        return;
                    }
                    ++n2;
                }
                ctx.setError("No method '" + redirectMethodName + "' on logic class");
            })).setValue((item, value) -> {
                String string = item.redirectValuesFunction = value;
            });
            ((FlagBuilder)builder.flag("HTTPS").init(item -> item.isSecure)).setValue((item, value) -> {
                boolean bl = item.isSecure = value.booleanValue();
            });
            ListBuilder links = ((ListBuilder)((ListBuilder)builder.list("Link HTTPS", LinkSecure.class).init(item -> item.links)).setValue((item, value) -> {
                List list = item.links = value;
            })).addItem(() -> new LinkSecure()).deleteItem();
            ((TextBuilder)links.text("Link").init(item -> ((LinkSecure)item).linkName)).setValue((item, value) -> {
                String string = value;
                String string2 = string;
                ((LinkSecure)item).linkName = string;
            });
            ((FlagBuilder)links.flag("HTTPS").init(item -> ((LinkSecure)item).isSecure)).setValue((item, value) -> {
                boolean bl = value;
                boolean bl2 = bl;
                ((LinkSecure)item).isSecure = bl;
            });
            ((TextBuilder)builder.text("Render HTTP methods").init(item -> item.renderHttpMethods)).setValue((item, value) -> {
                String string = item.renderHttpMethods = value;
            });
            ((TextBuilder)builder.text("Content-Type").init(item -> item.contentType)).setValue((item, value) -> {
                String string = item.contentType = value;
            });
            ((TextBuilder)builder.text("Charset").init(item -> item.charset)).setValue((item, value) -> {
                String string = item.charset = this.charset;
            });
            ((TextBuilder)((TextBuilder)builder.text("Link separator").init(item -> item.linkSeparatorCharacter)).validate(ctx -> {
                String character = (String)ctx.getValue().getValue();
                if (character == null) {
                    character = "";
                }
                if (character.trim().length() > 2) {
                    ctx.setError("May only have single character for link separator");
                }
            })).setValue((item, value) -> {
                String string = item.linkSeparatorCharacter = value;
            });
            builder.validate(ctx -> {
                WoofTemplateItem item = (WoofTemplateItem)((Object)((Object)((Object)ctx.getModel())));
                WebTemplateLoader loader = WebTemplateArchitectEmployer.employWebTemplateLoader((OfficeFloorCompiler)this.getConfigurableContext().getOsgiBridge().getOfficeFloorCompiler());
                WebTemplate template = loader.addTemplate(item.isSecure, item.applicationPath, item.location);
                template.setLogicClass(item.logicClass);
                template.setRedirectValuesFunction(item.redirectValuesFunction);
                template.setContentType(item.contentType);
                template.setCharset(item.charset);
                String separator = item.linkSeparatorCharacter;
                if (separator != null && separator.length() > 0) {
                    template.setLinkSeparatorCharacter(separator.charAt(0));
                }
                for (String method : this.translateFromCommaSeparatedList(item.renderHttpMethods, value -> value)) {
                    template.addRenderHttpMethod(method);
                }
                for (LinkSecure secure : item.links) {
                    template.setLinkSecure(secure.linkName, secure.isSecure);
                }
                WoofTemplateModel templateModel = (WoofTemplateModel)context.getModel();
                if (templateModel != null) {
                    ((WoofChanges)context.getOperations()).loadSuperTemplates(template, templateModel, loader);
                }
                item.type = loader.loadWebTemplateType(template);
                item.outputNameMapping = this.translateToNameMappings(item.type.getWebTemplateOutputTypes(), output -> output.getWebTemplateOutputName());
            });
        }).add((builder, context) -> builder.apply("Add", item -> {
            WoofTemplateExtension[] extensions = null;
            Map<String, Boolean> linksSecure = this.getLinksSecure((WoofTemplateItem)((Object)((Object)item)));
            String[] renderHttpMethods = this.translateFromCommaSeparatedList(item.renderHttpMethods, value -> value).toArray(new String[0]);
            WoofTemplateChangeContext changeContext = this.getWoofTemplateChangeContext((AbstractItem.ConfigurableContext<WoofModel, WoofChanges>)this.getConfigurableContext());
            context.execute(((WoofChanges)context.getOperations()).addTemplate(item.applicationPath, item.location, item.logicClass, item.type, item.redirectValuesFunction, item.contentType, item.charset, item.isSecure, item.linkSeparatorCharacter, linksSecure, renderHttpMethods, extensions, changeContext));
        })).refactor((builder, context) -> builder.apply("Refactor", item -> {
            Set inherited = null;
            WoofTemplateExtension[] extensions = null;
            Map<String, Boolean> linksSecure = this.getLinksSecure((WoofTemplateItem)((Object)((Object)item)));
            String[] renderHttpMethods = this.translateFromCommaSeparatedList(item.renderHttpMethods, value -> value).toArray(new String[0]);
            WoofTemplateChangeContext changeContext = this.getWoofTemplateChangeContext((AbstractItem.ConfigurableContext<WoofModel, WoofChanges>)this.getConfigurableContext());
            context.execute(((WoofChanges)context.getOperations()).refactorTemplate((WoofTemplateModel)context.getModel(), item.applicationPath, item.location, item.logicClass, item.type, item.redirectValuesFunction, inherited, item.contentType, item.charset, item.isSecure, item.linkSeparatorCharacter, linksSecure, renderHttpMethods, extensions, item.outputNameMapping, changeContext));
        })).delete(context -> {
            WoofTemplateChangeContext changeContext = this.getWoofTemplateChangeContext((AbstractItem.ConfigurableContext<WoofModel, WoofChanges>)this.getConfigurableContext());
            context.execute(((WoofChanges)context.getOperations()).removeTemplate((WoofTemplateModel)context.getModel(), changeContext));
        });
    }

    protected void children(List<AbstractItem.IdeChildrenGroup> childGroups) {
        childGroups.add(new AbstractItem.IdeChildrenGroup((AbstractItem)this, (AbstractItem)new WoofTemplateOutputItem()));
    }

    private static class LinkSecure {
        private String linkName = "";
        private boolean isSecure = true;

        private LinkSecure() {
        }

        private LinkSecure(WoofTemplateLinkModel link) {
            this.linkName = link.getWoofTemplateLinkName();
            this.isSecure = link.getIsLinkSecure();
        }
    }

    public static class MockLogic {
        public MockLogic redirect() {
            return this;
        }

        public void getTemplate(Flows flows) {
        }

        @FlowInterface
        public static interface Flows {
            public void flow();
        }
    }
}

