/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.woof;

import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.compile.properties.PropertyList;
import net.officefloor.eclipse.configurer.ClassBuilder;
import net.officefloor.eclipse.configurer.PropertiesBuilder;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedModelVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.woof.WoofEditor;
import net.officefloor.eclipse.woof.WoofSecurityOutputItem;
import net.officefloor.web.security.build.HttpSecurityArchitectEmployer;
import net.officefloor.web.security.scheme.BasicHttpSecuritySource;
import net.officefloor.web.security.type.HttpSecurityLoader;
import net.officefloor.web.security.type.HttpSecurityType;
import net.officefloor.web.spi.security.HttpSecuritySource;
import net.officefloor.woof.model.woof.WoofChanges;
import net.officefloor.woof.model.woof.WoofExceptionToWoofSecurityModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationToWoofSecurityModel;
import net.officefloor.woof.model.woof.WoofHttpInputToWoofSecurityModel;
import net.officefloor.woof.model.woof.WoofModel;
import net.officefloor.woof.model.woof.WoofSectionOutputToWoofSecurityModel;
import net.officefloor.woof.model.woof.WoofSecurityContentTypeModel;
import net.officefloor.woof.model.woof.WoofSecurityModel;
import net.officefloor.woof.model.woof.WoofSecurityOutputToWoofSecurityModel;
import net.officefloor.woof.model.woof.WoofTemplateOutputToWoofSecurityModel;

public class WoofSecurityItem
extends AbstractConfigurableItem<WoofModel, WoofModel.WoofEvent, WoofChanges, WoofSecurityModel, WoofSecurityModel.WoofSecurityEvent, WoofSecurityItem> {
    private String name;
    private String sourceClassName;
    private long timeout = 5000L;
    private PropertyList properties;
    private String contentTypes;
    private HttpSecurityType<?, ?, ?, ?, ?> type;
    private Map<String, String> flowNameMapping;

    public static void main(String[] args) {
        WoofEditor.launchConfigurer(new WoofSecurityItem(), model -> {
            model.setHttpSecurityName("Security");
            model.setHttpSecuritySourceClassName(BasicHttpSecuritySource.class.getName());
            model.setTimeout(1000L);
            model.addContentType(new WoofSecurityContentTypeModel("application/json"));
            model.addContentType(new WoofSecurityContentTypeModel("application/xml"));
        });
    }

    public WoofSecurityModel prototype() {
        return new WoofSecurityModel("Security", null, 0L);
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getWoofSecurities(), (Enum[])new WoofModel.WoofEvent[]{WoofModel.WoofEvent.ADD_WOOF_SECURITY, WoofModel.WoofEvent.REMOVE_WOOF_SECURITY});
    }

    public Pane visual(WoofSecurityModel model, AdaptedModelVisualFactoryContext<WoofSecurityModel> context) {
        VBox container = new VBox();
        HBox heading = (HBox)context.addNode((Pane)container, (Node)new HBox());
        context.addNode((Pane)heading, context.connector(DefaultConnectors.FLOW, new Class[]{WoofHttpContinuationToWoofSecurityModel.class, WoofHttpInputToWoofSecurityModel.class, WoofTemplateOutputToWoofSecurityModel.class, WoofSecurityOutputToWoofSecurityModel.class, WoofSectionOutputToWoofSecurityModel.class, WoofExceptionToWoofSecurityModel.class}).getNode());
        context.label((Pane)heading);
        context.addNode((Pane)container, (Node)((HBox)context.childGroup(WoofSecurityOutputItem.class.getSimpleName(), (Pane)new HBox())));
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getHttpSecurityName(), (Enum[])new WoofSecurityModel.WoofSecurityEvent[]{WoofSecurityModel.WoofSecurityEvent.CHANGE_HTTP_SECURITY_NAME});
    }

    public void loadToParent(WoofModel parentModel, WoofSecurityModel itemModel) {
        parentModel.addWoofSecurity(itemModel);
    }

    protected WoofSecurityItem item(WoofSecurityModel model) {
        WoofSecurityItem item = new WoofSecurityItem();
        if (model != null) {
            item.name = model.getHttpSecurityName();
            item.sourceClassName = model.getHttpSecuritySourceClassName();
            item.timeout = model.getTimeout();
            item.properties = this.translateToPropertyList(model.getProperties(), p -> p.getName(), p -> p.getValue());
            item.contentTypes = this.translateToCommaSeparateList(model.getContentTypes(), type -> type.getContentType());
        }
        return item;
    }

    protected void loadStyles(List<AbstractItem.IdeStyle> styles) {
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 50.0%, gold, goldenrod)"));
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this, ".${model} .label").rule("-fx-text-fill", "lightgoldenrodyellow"));
    }

    protected void children(List<AbstractItem.IdeChildrenGroup> childGroups) {
        childGroups.add(new AbstractItem.IdeChildrenGroup((AbstractItem)this, (AbstractItem)new WoofSecurityOutputItem()));
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("Security");
            ((TextBuilder)((TextBuilder)builder.text("Name").init(item -> item.name)).validate(ValueValidator.notEmptyString((String)"Must provide name"))).setValue((item, value) -> {
                String string = item.name = value;
            });
            ((ClassBuilder)((ClassBuilder)builder.clazz("Source").init(item -> item.sourceClassName)).superType(HttpSecuritySource.class).validate(ValueValidator.notEmptyString((String)"Must specify source"))).setValue((item, value) -> {
                String string = item.sourceClassName = value;
            });
            ((TextBuilder)((TextBuilder)builder.text("Timeout").init(item -> String.valueOf(item.timeout))).validate(ctx -> Long.parseLong((String)ctx.getValue().getValue()))).setValue((item, value) -> {
                long l = item.timeout = Long.parseLong(value);
            });
            ((PropertiesBuilder)builder.properties("Properties").init(item -> item.properties)).setValue((item, value) -> {
                PropertyList propertyList = item.properties = value;
            });
            ((TextBuilder)builder.text("Content Types").init(item -> item.contentTypes)).setValue((item, value) -> {
                String string = item.contentTypes = value;
            });
            builder.validate(ctx -> {
                WoofSecurityItem item = (WoofSecurityItem)((Object)((Object)((Object)ctx.getModel())));
                Class httpSecuritySourceClass = this.getConfigurableContext().getOsgiBridge().loadClass(item.sourceClassName, HttpSecuritySource.class);
                HttpSecurityLoader loader = HttpSecurityArchitectEmployer.employHttpSecurityLoader((OfficeFloorCompiler)this.getConfigurableContext().getOsgiBridge().getOfficeFloorCompiler());
                item.type = loader.loadHttpSecurityType(httpSecuritySourceClass, item.properties);
                item.flowNameMapping = this.translateToNameMappings(item.type.getFlowTypes(), flow -> flow.getFlowName());
            });
        }).add((builder, context) -> builder.apply("Add", item -> {
            String[] contentTypes = this.translateFromCommaSeparatedList(item.contentTypes, value -> value).toArray(new String[0]);
            context.execute(((WoofChanges)context.getOperations()).addSecurity(item.name, item.sourceClassName, item.timeout, item.properties, contentTypes, item.type));
        })).refactor((builder, context) -> builder.apply("Refactor", item -> {
            String[] contentTypes = this.translateFromCommaSeparatedList(item.contentTypes, value -> value).toArray(new String[0]);
            context.execute(((WoofChanges)context.getOperations()).refactorSecurity((WoofSecurityModel)context.getModel(), item.name, item.sourceClassName, item.timeout, item.properties, contentTypes, item.type, item.flowNameMapping));
        })).delete(context -> context.execute(((WoofChanges)context.getOperations()).removeSecurity((WoofSecurityModel)context.getModel())));
    }
}

