/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.woof;

import java.util.List;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.configurer.TextBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedModelVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.woof.WoofEditor;
import net.officefloor.woof.model.woof.WoofChanges;
import net.officefloor.woof.model.woof.WoofExceptionToWoofResourceModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationToWoofResourceModel;
import net.officefloor.woof.model.woof.WoofHttpInputToWoofResourceModel;
import net.officefloor.woof.model.woof.WoofModel;
import net.officefloor.woof.model.woof.WoofResourceModel;
import net.officefloor.woof.model.woof.WoofSectionOutputToWoofResourceModel;
import net.officefloor.woof.model.woof.WoofSecurityOutputToWoofResourceModel;
import net.officefloor.woof.model.woof.WoofTemplateOutputToWoofResourceModel;

public class WoofResourceItem
extends AbstractConfigurableItem<WoofModel, WoofModel.WoofEvent, WoofChanges, WoofResourceModel, WoofResourceModel.WoofResourceEvent, WoofResourceItem> {
    private String resourcePath;

    public static void main(String[] args) {
        WoofEditor.launchConfigurer(new WoofResourceItem(), model -> model.setResourcePath("/resource"));
    }

    public WoofResourceModel prototype() {
        return new WoofResourceModel("Resource");
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getWoofResources(), (Enum[])new WoofModel.WoofEvent[]{WoofModel.WoofEvent.ADD_WOOF_RESOURCE, WoofModel.WoofEvent.REMOVE_WOOF_RESOURCE});
    }

    public Pane visual(WoofResourceModel model, AdaptedModelVisualFactoryContext<WoofResourceModel> context) {
        HBox container = new HBox();
        context.addNode((Pane)container, context.connector(DefaultConnectors.FLOW, new Class[]{WoofHttpContinuationToWoofResourceModel.class, WoofHttpInputToWoofResourceModel.class, WoofTemplateOutputToWoofResourceModel.class, WoofSecurityOutputToWoofResourceModel.class, WoofSectionOutputToWoofResourceModel.class, WoofExceptionToWoofResourceModel.class}).getNode());
        context.label((Pane)container);
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getResourcePath(), (Enum[])new WoofResourceModel.WoofResourceEvent[]{WoofResourceModel.WoofResourceEvent.CHANGE_RESOURCE_PATH});
    }

    public void loadToParent(WoofModel parentModel, WoofResourceModel itemModel) {
        parentModel.addWoofResource(itemModel);
    }

    protected WoofResourceItem item(WoofResourceModel model) {
        WoofResourceItem item = new WoofResourceItem();
        if (model != null) {
            item.resourcePath = model.getResourcePath();
        }
        return item;
    }

    protected void loadStyles(List<AbstractItem.IdeStyle> styles) {
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 100.0%, mediumslateblue, mediumpurple)"));
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this, ".${model} .label").rule("-fx-text-fill", "lavender"));
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("Resource");
            ((TextBuilder)((TextBuilder)builder.text("Resource Path").init(item -> item.resourcePath)).validate(ValueValidator.notEmptyString((String)"Must provide resource path"))).setValue((item, value) -> {
                String string = item.resourcePath = value;
            });
        }).add((builder, context) -> builder.apply("Add", item -> context.execute(((WoofChanges)context.getOperations()).addResource(item.resourcePath)))).refactor((builder, context) -> builder.apply("Refactor", item -> context.execute(((WoofChanges)context.getOperations()).refactorResource((WoofResourceModel)context.getModel(), item.resourcePath)))).delete(context -> context.execute(((WoofChanges)context.getOperations()).removeResource((WoofResourceModel)context.getModel())));
    }
}

