/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.woof;

import java.io.IOException;
import java.util.List;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.configurer.ClassBuilder;
import net.officefloor.eclipse.configurer.ValueValidator;
import net.officefloor.eclipse.editor.AdaptedModelVisualFactoryContext;
import net.officefloor.eclipse.editor.DefaultConnectors;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractItem;
import net.officefloor.eclipse.woof.WoofEditor;
import net.officefloor.model.ConnectionModel;
import net.officefloor.woof.model.woof.WoofChanges;
import net.officefloor.woof.model.woof.WoofExceptionModel;
import net.officefloor.woof.model.woof.WoofExceptionToWoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofExceptionToWoofResourceModel;
import net.officefloor.woof.model.woof.WoofExceptionToWoofSectionInputModel;
import net.officefloor.woof.model.woof.WoofExceptionToWoofSecurityModel;
import net.officefloor.woof.model.woof.WoofExceptionToWoofTemplateModel;
import net.officefloor.woof.model.woof.WoofHttpContinuationModel;
import net.officefloor.woof.model.woof.WoofModel;
import net.officefloor.woof.model.woof.WoofResourceModel;
import net.officefloor.woof.model.woof.WoofSectionInputModel;
import net.officefloor.woof.model.woof.WoofSecurityModel;
import net.officefloor.woof.model.woof.WoofTemplateModel;

public class WoofExceptionItem
extends AbstractConfigurableItem<WoofModel, WoofModel.WoofEvent, WoofChanges, WoofExceptionModel, WoofExceptionModel.WoofExceptionEvent, WoofExceptionItem> {
    private String exceptionClassName;

    public static void main(String[] args) {
        WoofEditor.launchConfigurer(new WoofExceptionItem(), model -> model.setClassName(IOException.class.getName()));
    }

    public WoofExceptionModel prototype() {
        return new WoofExceptionModel("Exception");
    }

    public AbstractItem.IdeExtractor extract() {
        return new AbstractItem.IdeExtractor((AbstractItem)this, parent -> parent.getWoofExceptions(), (Enum[])new WoofModel.WoofEvent[]{WoofModel.WoofEvent.ADD_WOOF_EXCEPTION, WoofModel.WoofEvent.REMOVE_WOOF_EXCEPTION});
    }

    public Pane visual(WoofExceptionModel model, AdaptedModelVisualFactoryContext<WoofExceptionModel> context) {
        HBox container = new HBox();
        context.label((Pane)container);
        context.addNode((Pane)container, context.connector(DefaultConnectors.FLOW, new Class[]{WoofExceptionToWoofSectionInputModel.class, WoofExceptionToWoofTemplateModel.class, WoofExceptionToWoofResourceModel.class, WoofExceptionToWoofSecurityModel.class, WoofExceptionToWoofHttpContinuationModel.class}).getNode());
        return container;
    }

    public AbstractItem.IdeLabeller label() {
        return new AbstractItem.IdeLabeller((AbstractItem)this, model -> model.getClassName(), (Enum[])new WoofExceptionModel.WoofExceptionEvent[]{WoofExceptionModel.WoofExceptionEvent.CHANGE_CLASS_NAME});
    }

    public void loadToParent(WoofModel parentModel, WoofExceptionModel itemModel) {
        parentModel.addWoofException(itemModel);
    }

    protected WoofExceptionItem item(WoofExceptionModel model) {
        WoofExceptionItem item = new WoofExceptionItem();
        if (model != null) {
            item.exceptionClassName = model.getClassName();
        }
        return item;
    }

    protected void loadStyles(List<AbstractItem.IdeStyle> styles) {
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this).rule("-fx-background-color", "radial-gradient(radius 100.0%, tomato, darkorange)"));
        styles.add(new AbstractItem.IdeStyle((AbstractItem)this, ".${model} .label").rule("-fx-text-fill", "moccasin"));
    }

    protected void connections(List<AbstractItem.IdeConnectionTarget<? extends ConnectionModel, ?, ?>> connections) {
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofExceptionToWoofSectionInputModel.class).connectOne(s -> s.getWoofSectionInput(), c -> c.getWoofException(), (Enum[])new WoofExceptionModel.WoofExceptionEvent[]{WoofExceptionModel.WoofExceptionEvent.CHANGE_WOOF_SECTION_INPUT}).to(WoofSectionInputModel.class).many(t -> t.getWoofExceptions(), c -> c.getWoofSectionInput(), new Enum[]{WoofSectionInputModel.WoofSectionInputEvent.ADD_WOOF_EXCEPTION, WoofSectionInputModel.WoofSectionInputEvent.REMOVE_WOOF_EXCEPTION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkExceptionToSectionInput(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeExceptionToSectionInput((WoofExceptionToWoofSectionInputModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofExceptionToWoofTemplateModel.class).connectOne(s -> s.getWoofTemplate(), c -> c.getWoofException(), (Enum[])new WoofExceptionModel.WoofExceptionEvent[]{WoofExceptionModel.WoofExceptionEvent.CHANGE_WOOF_TEMPLATE}).to(WoofTemplateModel.class).many(t -> t.getWoofExceptions(), c -> c.getWoofTemplate(), new Enum[]{WoofTemplateModel.WoofTemplateEvent.ADD_WOOF_EXCEPTION, WoofTemplateModel.WoofTemplateEvent.REMOVE_WOOF_EXCEPTION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkExceptionToTemplate(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeExceptionToTemplate((WoofExceptionToWoofTemplateModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofExceptionToWoofResourceModel.class).connectOne(s -> s.getWoofResource(), c -> c.getWoofException(), (Enum[])new WoofExceptionModel.WoofExceptionEvent[]{WoofExceptionModel.WoofExceptionEvent.CHANGE_WOOF_RESOURCE}).to(WoofResourceModel.class).many(t -> t.getWoofExceptions(), c -> c.getWoofResource(), new Enum[]{WoofResourceModel.WoofResourceEvent.ADD_WOOF_EXCEPTION, WoofResourceModel.WoofResourceEvent.REMOVE_WOOF_EXCEPTION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkExceptionToResource(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeExceptionToResource((WoofExceptionToWoofResourceModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofExceptionToWoofSecurityModel.class).connectOne(s -> s.getWoofSecurity(), c -> c.getWoofException(), (Enum[])new WoofExceptionModel.WoofExceptionEvent[]{WoofExceptionModel.WoofExceptionEvent.CHANGE_WOOF_SECURITY}).to(WoofSecurityModel.class).many(t -> t.getWoofExceptions(), c -> c.getWoofSecurity(), new Enum[]{WoofSecurityModel.WoofSecurityEvent.ADD_WOOF_EXCEPTION, WoofSecurityModel.WoofSecurityEvent.REMOVE_WOOF_EXCEPTION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkExceptionToSecurity(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeExceptionToSecurity((WoofExceptionToWoofSecurityModel)ctx.getModel()))));
        connections.add(new AbstractItem.IdeConnection((AbstractItem)this, WoofExceptionToWoofHttpContinuationModel.class).connectOne(s -> s.getWoofHttpContinuation(), c -> c.getWoofException(), (Enum[])new WoofExceptionModel.WoofExceptionEvent[]{WoofExceptionModel.WoofExceptionEvent.CHANGE_WOOF_HTTP_CONTINUATION}).to(WoofHttpContinuationModel.class).many(t -> t.getWoofExceptions(), c -> c.getWoofHttpContinuation(), new Enum[]{WoofHttpContinuationModel.WoofHttpContinuationEvent.ADD_WOOF_EXCEPTION, WoofHttpContinuationModel.WoofHttpContinuationEvent.REMOVE_WOOF_EXCEPTION}).create((s, t, ctx) -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).linkExceptionToHttpContinuation(s, t))).delete(ctx -> ctx.getChangeExecutor().execute(((WoofChanges)ctx.getOperations()).removeExceptionToHttpContinuation((WoofExceptionToWoofHttpContinuationModel)ctx.getModel()))));
    }

    public AbstractConfigurableItem.IdeConfigurer configure() {
        return new AbstractConfigurableItem.IdeConfigurer((AbstractConfigurableItem)this).addAndRefactor((builder, context) -> {
            builder.title("Exception");
            ((ClassBuilder)((ClassBuilder)builder.clazz("Exception").init(item -> item.exceptionClassName)).superType(Throwable.class).validate(ValueValidator.notEmptyString((String)"Must provide exception class"))).setValue((item, value) -> {
                String string = item.exceptionClassName = value;
            });
        }).add((builder, context) -> builder.apply("Add", item -> context.execute(((WoofChanges)context.getOperations()).addException(item.exceptionClassName)))).refactor((builder, context) -> builder.apply("Refactor", item -> context.execute(((WoofChanges)context.getOperations()).refactorException((WoofExceptionModel)context.getModel(), item.exceptionClassName)))).delete(context -> context.execute(((WoofChanges)context.getOperations()).removeException((WoofExceptionModel)context.getModel())));
    }
}

