/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.woof;

import java.util.List;
import java.util.function.Consumer;
import net.officefloor.configuration.ConfigurationItem;
import net.officefloor.configuration.WritableConfigurationItem;
import net.officefloor.eclipse.ide.editor.AbstractConfigurableItem;
import net.officefloor.eclipse.ide.editor.AbstractIdeEditor;
import net.officefloor.eclipse.woof.WoofExceptionItem;
import net.officefloor.eclipse.woof.WoofHttpContinuationItem;
import net.officefloor.eclipse.woof.WoofHttpInputItem;
import net.officefloor.eclipse.woof.WoofResourceItem;
import net.officefloor.eclipse.woof.WoofSectionItem;
import net.officefloor.eclipse.woof.WoofSecurityItem;
import net.officefloor.eclipse.woof.WoofStartItem;
import net.officefloor.eclipse.woof.WoofTemplateItem;
import net.officefloor.model.Model;
import net.officefloor.model.impl.repository.ModelRepositoryImpl;
import net.officefloor.model.repository.ModelRepository;
import net.officefloor.woof.model.woof.WoofChanges;
import net.officefloor.woof.model.woof.WoofChangesImpl;
import net.officefloor.woof.model.woof.WoofModel;
import net.officefloor.woof.model.woof.WoofRepository;
import net.officefloor.woof.model.woof.WoofRepositoryImpl;

public class WoofEditor
extends AbstractIdeEditor<WoofModel, WoofModel.WoofEvent, WoofChanges> {
    private static final WoofRepository WOOF_REPOSITORY = new WoofRepositoryImpl((ModelRepository)new ModelRepositoryImpl());

    public static void main(String[] args) throws Exception {
        WoofEditor.launch((String)"<woof />");
    }

    public static <M extends Model, E extends Enum<E>, I> void launchConfigurer(AbstractConfigurableItem<WoofModel, WoofModel.WoofEvent, WoofChanges, M, E, I> configurableItem, Consumer<M> prototypeDecorator) {
        configurableItem.main((Model)new WoofModel(), WoofEditor.class, prototypeDecorator);
    }

    public WoofEditor() {
        super(WoofModel.class, model -> new WoofChangesImpl(model));
    }

    public String fileName() {
        return "application.woof";
    }

    public WoofModel prototype() {
        return new WoofModel();
    }

    public String paletteStyle() {
        return ".palette { -fx-background-color: cornsilk }";
    }

    public String paletteIndicatorStyle() {
        return ".palette-indicator { -fx-background-color: bisque }";
    }

    public String editorStyle() {
        return ".connection Path { -fx-stroke: royalblue; -fx-opacity: 0.6 }";
    }

    protected void loadParents(List<AbstractConfigurableItem<WoofModel, WoofModel.WoofEvent, WoofChanges, ?, ?, ?>> parents) {
        parents.add(new WoofHttpContinuationItem());
        parents.add(new WoofHttpInputItem());
        parents.add(new WoofTemplateItem());
        parents.add(new WoofSecurityItem());
        parents.add(new WoofSectionItem());
        parents.add(new WoofResourceItem());
        parents.add(new WoofExceptionItem());
        parents.add(new WoofStartItem());
    }

    protected WoofModel loadRootModel(ConfigurationItem configurationItem) throws Exception {
        WoofModel woof = new WoofModel();
        WOOF_REPOSITORY.retrieveWoof(woof, configurationItem);
        return woof;
    }

    public void saveRootModel(WoofModel model, WritableConfigurationItem configurationItem) throws Exception {
        WOOF_REPOSITORY.storeWoof(model, configurationItem);
    }
}

