/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class Node<T> {
    private Node<T> parent;
    private T value;
    private List<Node<T>> children;

    public Node(T value) {
        this.value = value;
    }

    public Node(T value, List<Node<T>> children) {
        this.value = value;
        this.children = children;
    }

    public Node(Node<T> parent, T value, List<Node<T>> children) {
        this.parent = parent;
        this.value = value;
        this.children = children;
    }

    public List<Node<T>> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Node<T>>();
        }
        return this.children;
    }

    public Node<T> add(T value) {
        this.getChildren().add(new Node<T>(this, value, null));
        return this;
    }

    public Node<T> append(Node<T> node) {
        this.getChildren().add(node.parent(this));
        return this;
    }

    public Node<T> parent(Node<T> node) {
        this.parent = node;
        return this;
    }

    public Node<T> prune() {
        if (!this.hasChildren()) {
            return this;
        }
        ArrayList<Node<T>> newChildren = new ArrayList<Node<T>>(this.children);
        Iterator<Node<T>> itr = newChildren.iterator();
        while (itr.hasNext()) {
            Node<T> next = itr.next();
            if (!next.hasChildren()) {
                next.prune();
                continue;
            }
            itr.remove();
        }
        return new Node<T>(this.value, newChildren);
    }

    public List<Node<T>> getLeafNodes() {
        if (!this.hasChildren()) {
            return Collections.singletonList(this);
        }
        ArrayList<Node<T>> ret = new ArrayList<Node<T>>();
        for (Node<T> child : this.children) {
            ret.addAll(child.getLeafNodes());
        }
        return ret;
    }

    public List<T> getLeaves() {
        if (!this.hasChildren()) {
            return Collections.singletonList(this.getValue());
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (Node<T> child : this.children) {
            ret.addAll(child.getLeaves());
        }
        return ret;
    }

    public void visitDepthFirst(Consumer<T> visitor) {
        visitor.accept(this.value);
        for (Node<T> child : this.children) {
            child.visitDepthFirst(visitor);
        }
    }

    protected void visitBreadthFirst(Consumer<T> visitor) {
        this.visitBreadthFirst(true, visitor);
    }

    protected void visitBreadthFirst(boolean visitRoot, Consumer<T> visitor) {
        if (visitRoot) {
            visitor.accept(this.value);
        }
        for (Node<T> child : this.children) {
            visitor.accept(child.value);
        }
        for (Node<T> child : this.children) {
            child.visitBreadthFirst(false, visitor);
        }
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public T getValue() {
        return this.value;
    }
}

