/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ListBackedSet<E>
extends AbstractSet<E> {
    private List<E> values;

    public ListBackedSet(int size) {
        this.values = new ArrayList(size);
    }

    public ListBackedSet(List<E> values) {
        this.values = Objects.requireNonNull(values, "values is a required parameter");
    }

    @Override
    public Iterator<E> iterator() {
        return this.values.iterator();
    }

    @Override
    public boolean add(E e) {
        for (int i = 0; i < this.values.size(); ++i) {
            E value = this.values.get(i);
            if (!Objects.equals(e, value)) continue;
            this.values.set(i, e);
            return false;
        }
        this.values.add(e);
        return true;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListBackedSet)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListBackedSet that = (ListBackedSet)o;
        return Objects.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.values);
    }
}

