/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Objects;

public class IO {
    public static void pipe(InputStream is, OutputStream os) {
        try {
            Objects.requireNonNull(is).transferTo(Objects.requireNonNull(os));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String streamToString(InputStream is) {
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = "";
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return builder.toString();
    }
}

