/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.util;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.odoframework.util.Strings;

public class ConfigLoader {
    public static final Properties loadProperties(String ... files) {
        return ConfigLoader.loadProperties(ConfigLoader.class.getModule(), files);
    }

    public static final Properties loadProperties(Module contextClassLoader, String ... files) {
        Properties properties = new Properties();
        for (String file : files) {
            try {
                properties.load(contextClassLoader.getResourceAsStream(file));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(file + " could not be loaded");
            }
        }
        System.getenv().forEach((key, value) -> properties.put("env." + key, value));
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::put));
        return properties;
    }

    public static Properties findByPrefix(Properties p, String prefix, boolean stripPrefix) {
        Properties result = new Properties();
        result.putAll(Objects.requireNonNull(p, "properties is a required parameter").entrySet().stream().filter(it -> it.getKey().toString().startsWith(prefix)).filter(it -> it.getValue() != null).collect(Collectors.toMap(entry -> {
            if (stripPrefix) {
                return ConfigLoader.stripPrefix(entry.getKey().toString(), prefix);
            }
            return entry.getKey();
        }, Map.Entry::getValue)));
        return result;
    }

    public static String stripPrefix(String str, String prefix) {
        if (Strings.isBlank(str) || Strings.isBlank(prefix)) {
            return prefix;
        }
        if (!str.startsWith(prefix)) {
            throw new IllegalArgumentException(str + " does not start with the the prefix: " + prefix);
        }
        String remainder = str.substring(prefix.length());
        if (remainder.startsWith(".") && remainder.length() > 1) {
            return remainder.substring(1).trim();
        }
        if (remainder.startsWith(".")) {
            return "";
        }
        return remainder.trim();
    }
}

