/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.odoframework.sql.ColumnIndex;
import net.odoframework.sql.SQLWrappedException;
import net.odoframework.util.ListBackedMap;
import net.odoframework.util.NullSafe;

public class SQLUtils {
    private static Map<String, Map<String, ColumnIndex>> QUERY_INDICES = new LinkedHashMap<String, Map<String, ColumnIndex>>();

    public static Map<String, ColumnIndex> getIndex(String sql) {
        return QUERY_INDICES.get(sql);
    }

    public static void set(String sql, Map<String, ColumnIndex> index) {
        QUERY_INDICES.put(sql, index);
    }

    public static Map<String, ColumnIndex> getIndex(String sql, ResultSet rs) {
        return QUERY_INDICES.computeIfAbsent(sql, key -> SQLUtils.indexResultSet(rs));
    }

    public static <T> T getColumn(ResultSet rs, int index) {
        return (T)SQLWrappedException.get(() -> rs.getObject(index));
    }

    public static Map<String, ColumnIndex> indexResultSet(ResultSet rs) {
        LinkedHashMap<String, ColumnIndex> index = new LinkedHashMap<String, ColumnIndex>();
        SQLWrappedException.run(() -> {
            ResultSetMetaData metaData = rs.getMetaData();
            int cols = metaData.getColumnCount();
            for (int i = 1; i <= cols; ++i) {
                String table = metaData.getTableName(i).toLowerCase();
                String column = metaData.getColumnName(i).toLowerCase();
                ColumnIndex indexTable = index.computeIfAbsent(table, key -> new ColumnIndex());
                indexTable.put(column, i);
            }
        });
        return index;
    }

    public static void dumpRow(Object[] row) {
        for (Object o : row) {
            System.out.print((String)NullSafe.safe(() -> o.toString(), null));
            System.out.print(" ");
        }
        System.out.println();
    }

    public static Object[] row(ResultSet rs) {
        return SQLWrappedException.get(() -> {
            ResultSetMetaData metaData = rs.getMetaData();
            int cols = metaData.getColumnCount();
            Object[] row = new Object[cols];
            for (int i = 1; i <= cols; ++i) {
                row[i - 1] = rs.getObject(i);
            }
            return row;
        });
    }

    public static void toMap(ResultSet rs, Consumer<Map<String, ?>> rowHandler) {
        SQLWrappedException.run(() -> {
            ResultSetMetaData metaData = rs.getMetaData();
            int cols = metaData.getColumnCount();
            ListBackedMap<String, Object> row = new ListBackedMap<String, Object>(cols);
            while (rs.next()) {
                for (int i = 1; i <= cols; ++i) {
                    row.put(metaData.getColumnLabel(i), rs.getObject(i));
                }
                rowHandler.accept(row);
            }
        });
    }

    public static void toArray(ResultSet rs, Consumer<Object[]> rowHandler) {
        SQLWrappedException.run(() -> {
            ResultSetMetaData metaData = rs.getMetaData();
            int cols = metaData.getColumnCount();
            Object[] row = new Object[cols];
            while (rs.next()) {
                for (int i = 1; i <= cols; ++i) {
                    row[i - 1] = rs.getObject(i);
                }
                rowHandler.accept(row);
            }
        });
    }
}

