/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.odoframework.http.Credentials;
import net.odoframework.util.Strings;

public class HttpRequest {
    private String method = "GET";
    private Map<String, List<String>> headers;
    private URI uri;
    private Credentials credentials;
    private InputStream body;
    private Charset charSet = StandardCharsets.UTF_8;
    private int timeout = 30000;

    public HttpRequest(URI uri) {
        this.uri = Objects.requireNonNull(uri, "uri is a required parameter");
    }

    public static final HttpRequest get(URI uri) {
        return new HttpRequest(uri);
    }

    public static final HttpRequest post(URI uri) {
        return new HttpRequest(uri).method("POST");
    }

    public static final HttpRequest put(URI uri) {
        return new HttpRequest(uri).method("PUT");
    }

    public static final HttpRequest delete(URI uri) {
        return new HttpRequest(uri).method("DELETE");
    }

    public static final HttpRequest head(URI uri) {
        return new HttpRequest(uri).method("HEAD");
    }

    public HttpRequest header(String name, String ... values) {
        List<String> valuesList = Arrays.asList(values);
        this.getHeaders().put(Strings.requireNotBlank(name), valuesList);
        return this;
    }

    public HttpRequest credentials(Credentials credentials) {
        this.credentials = Objects.requireNonNull(credentials, "credentials cannot be null");
        return this;
    }

    public HttpRequest body(InputStream inputStream) {
        this.body = Objects.requireNonNull(inputStream, "inputstream cannot be null");
        return this;
    }

    public HttpRequest method(String method) {
        this.method = Strings.requireNotBlank(method, "method cannot be null");
        return this;
    }

    public HttpRequest timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpRequest charSet(Charset charSet) {
        this.charSet = Objects.requireNonNull(charSet);
        return this;
    }

    public HttpRequest body(String body) {
        return this.body(new ByteArrayInputStream(Strings.requireNotBlank(body).getBytes(this.charSet)));
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, List<String>>();
        }
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public URL getUrl() {
        try {
            return this.getUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public InputStream getBody() {
        return this.body;
    }

    public Charset getCharSet() {
        return this.charSet;
    }

    public int getTimeout() {
        return this.timeout;
    }
}

