/*
 * Decompiled with CFR 0.152.
 */
package net.odoframework.http;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import net.odoframework.http.Credentials;
import net.odoframework.util.Pair;
import net.odoframework.util.Strings;

public class BasicAuth
implements Credentials {
    private final String user;
    private final String password;

    public BasicAuth(String user, String password) {
        this.user = Strings.requireNotBlank(user, "user is a required parameter").trim();
        this.password = Strings.requireNotBlank(password, "password is a required parameter").trim();
    }

    public static BasicAuth basicAuth(String user, String password) {
        return new BasicAuth(user, password);
    }

    public String authString() {
        return String.join((CharSequence)":", this.user, this.password);
    }

    public String authStringEncoded() {
        return String.join((CharSequence)" ", "Basic", Base64.getEncoder().encodeToString(this.authString().getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public Collection<Pair<String, String>> toHeader() {
        return Collections.singleton(Pair.cons("Authorization", this.authStringEncoded()));
    }
}

