/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface SessionIdStore {
    public void put(String var1, String var2);

    public void remove(String var1);

    public String getLogin(String var1);

    public static SessionIdStore inMemory() {
        return new SessionIdStore(){
            private final Map<String, String> sessionIds = new ConcurrentHashMap<String, String>();

            @Override
            public void put(String sessionId, String login) {
                this.sessionIds.put(sessionId, login);
            }

            @Override
            public void remove(String sessionId) {
                this.sessionIds.remove(sessionId);
            }

            @Override
            public String getLogin(String sessionId) {
                return this.sessionIds.get(sessionId);
            }
        };
    }
}

