/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.osxwatcher;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import net.codestory.http.osxwatcher.CarbonAPI;
import net.codestory.http.osxwatcher.FileChangeListener;

public class Watcher {
    private static final double LATENCY_S = 0.5;
    private static final int FLAGS = 2;
    private final WatcherLoop loop;

    public Watcher(File folder, FileChangeListener listener) {
        this.loop = new WatcherLoop(folder, listener);
    }

    public void start() {
        Thread thread = new Thread(this.loop);
        thread.setDaemon(true);
        thread.start();
        try {
            this.loop.started.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.loop.stop();
    }

    static class WatcherLoop
    implements CarbonAPI.FSEventStreamCallback,
    Runnable {
        private final File folder;
        private final FileChangeListener listener;
        final CountDownLatch started;
        private PointerByReference stream;
        private PointerByReference runLoop;

        public WatcherLoop(File folder, FileChangeListener listener) {
            this.folder = folder;
            this.listener = listener;
            this.started = new CountDownLatch(1);
        }

        @Override
        public void run() {
            CarbonAPI api = CarbonAPI.INSTANCE;
            PointerByReference path = api.CFArrayCreate(null, new Pointer[]{CarbonAPI.toCFString(this.folder.getAbsolutePath()).getPointer()}, new NativeLong(1L), null);
            this.stream = api.FSEventStreamCreate(Pointer.NULL, this, Pointer.NULL, path, -1L, 0.5, 2);
            this.runLoop = api.CFRunLoopGetCurrent();
            api.FSEventStreamScheduleWithRunLoop(this.stream, this.runLoop, CarbonAPI.toCFString("kCFRunLoopDefaultMode"));
            api.FSEventStreamStart(this.stream);
            this.started.countDown();
            api.CFRunLoopRun();
        }

        public void stop() {
            CarbonAPI.INSTANCE.CFRunLoopStop(this.runLoop);
            CarbonAPI.INSTANCE.FSEventStreamStop(this.stream);
        }

        @Override
        public void invoke(PointerByReference streamRef, Pointer clientCallBackInfo, NativeLong numEvents, Pointer eventPaths, Pointer eventFlags, Pointer eventIds) {
            this.listener.onChange();
        }
    }
}

