/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

@FunctionalInterface
public interface FileVisitor
extends Serializable {
    public void accept(Path var1) throws IOException;

    public static SimpleFileVisitor<Path> onFile(final FileVisitor visitor) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                visitor.accept(file);
                return FileVisitResult.CONTINUE;
            }
        };
    }

    public static SimpleFileVisitor<Path> onDirectory(final FileVisitor visitor) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attr) throws IOException {
                visitor.accept(dir);
                return FileVisitResult.CONTINUE;
            }
        };
    }
}

