/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import net.codestory.http.internal.SimpleFrame;
import net.codestory.http.websockets.WebSocketListener;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameListener;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.Reason;
import org.simpleframework.http.socket.Session;

class SimpleWebSocketListener
implements FrameListener {
    private final WebSocketListener listener;

    SimpleWebSocketListener(WebSocketListener listener) {
        this.listener = listener;
    }

    public void onFrame(Session session, Frame frame) {
        FrameType type = frame.getType();
        if (!type.isPing() && !type.isPong()) {
            try {
                this.listener.onFrame(new SimpleFrame(frame));
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to handle frame", e);
            }
        }
    }

    public void onError(Session session, Exception cause) {
        try {
            this.listener.onError(cause);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to handle error", e);
        }
    }

    public void onClose(Session session, Reason reason) {
        try {
            this.listener.onClose(reason.getCode().code, reason.getText());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to handle close", e);
        }
    }
}

