/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.basic;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import net.codestory.http.Context;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.payload.Payload;
import net.codestory.http.security.User;
import net.codestory.http.security.Users;

public class BasicAuthFilter
implements Filter {
    private final String uriPrefix;
    private final String realm;
    private final Users users;

    public BasicAuthFilter(String uriPrefix, String realm, Users users) {
        this.uriPrefix = uriPrefix;
        this.realm = realm;
        this.users = users;
    }

    @Override
    public boolean matches(String uri, Context context) {
        return uri.startsWith(this.uriPrefix);
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws Exception {
        String password;
        String authorization = context.header("Authorization");
        if (authorization == null || !authorization.toLowerCase(Locale.ENGLISH).startsWith("basic ")) {
            return Payload.unauthorized(this.realm);
        }
        String base64Pwd = authorization.substring("basic ".length());
        String auth = new String(Base64.getDecoder().decode(base64Pwd), StandardCharsets.UTF_8);
        int i = auth.indexOf(58);
        if (i < 0) {
            return Payload.badRequest();
        }
        String login = auth.substring(0, i);
        User user = this.users.find(login, password = auth.substring(i + 1));
        if (user == null) {
            return Payload.unauthorized(this.realm);
        }
        context.setCurrentUser(user);
        return nextFilter.get().withHeader("Cache-Control", "must-revalidate");
    }
}

