/**
 * Copyright (C) 2013-2014 all@code-story.net
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */
package net.codestory.http;

import net.codestory.http.filters.log.*;
import net.codestory.http.internal.*;
import net.codestory.http.websockets.*;

public class WebServer extends AbstractWebServer<WebServer> {
  public static void main(String[] args) {
    new WebServer()
      .configure(routes -> routes.filter(new LogRequestFilter()))
      .start();
  }

  @Override
  protected HttpServerWrapper createHttpServer(Handler httpHandler, WebSocketHandler webSocketHandler) throws Exception {
    return new SimpleServerWrapper(httpHandler, webSocketHandler);
  }
}
