/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.injection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.injection.IocAdapter;

public class Singletons
implements IocAdapter {
    private final Map<Class<?>, Object> singletons = new HashMap();

    public Singletons(Object ... beansToRegister) {
        this.register(Singletons.class, this);
        for (Object beanToRegister : beansToRegister) {
            Class<?> type = beanToRegister.getClass();
            if (type.getName().contains("EnhancerByMockito")) {
                type = type.getSuperclass();
            }
            this.register(type, beanToRegister);
        }
    }

    public <T> Singletons register(Class<? extends T> type, T singleton) {
        this.singletons.put(type, singleton);
        return this;
    }

    @Override
    public synchronized <T> T get(Class<T> type) {
        Object singleton = this.singletons.get(type);
        if (singleton != null) {
            return (T)singleton;
        }
        return this._get(type, 0);
    }

    private <T> T _get(Class<T> type, int depth) {
        Object singleton = this.singletons.get(type);
        if (singleton != null) {
            return (T)singleton;
        }
        if (depth > 100) {
            throw new IllegalStateException("Cycle in dependencies for " + type);
        }
        try {
            T instance = this.create(type, depth);
            this.singletons.put(type, instance);
            return instance;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to create instance of " + type + ". The constructor raised an exception", e.getCause());
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException e) {
            throw new IllegalStateException("Unable to create instance of " + type, e);
        }
    }

    private <T> T create(Class<T> type, int depth) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> constructor = Singletons.getConstructor(type);
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = this._get(parameterTypes[i], depth + 1);
        }
        return constructor.newInstance(parameters);
    }

    private static <T> Constructor<T> getConstructor(Class<T> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?>[] constructors = type.getConstructors();
            if (constructors.length != 1) {
                throw new IllegalStateException("Class " + type + " should have a single public constructor");
            }
            return constructors[0];
        }
    }
}

