/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.types;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.codestory.http.io.Resources;

public class ContentTypes {
    public static final String[] TEMPLATE_EXTENSIONS = new String[]{"", ".html", ".md", ".markdown", ".txt"};
    public static final List<String> SIMPLE_HTTP_REQUEST_CONTENT_TYPE_VALUES = Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain");

    private ContentTypes() {
    }

    public static String get(Path path) {
        switch (Resources.extension(path)) {
            case ".html": 
            case ".md": 
            case ".markdown": {
                return "text/html;charset=UTF-8";
            }
            case ".xml": {
                return "application/xml;charset=UTF-8";
            }
            case ".css": 
            case ".less": {
                return "text/css;charset=UTF-8";
            }
            case ".js": 
            case ".coffee": 
            case ".litcoffee": {
                return "application/javascript;charset=UTF-8";
            }
            case ".zip": {
                return "application/zip";
            }
            case ".gz": {
                return "application/gzip";
            }
            case ".pdf": {
                return "application/pdf";
            }
            case ".gif": {
                return "image/gif";
            }
            case ".jpeg": 
            case ".jpg": {
                return "image/jpeg";
            }
            case ".png": {
                return "image/png";
            }
            case ".svg": {
                return "image/svg+xml";
            }
            case ".eot": {
                return "application/vnd.ms-fontobject";
            }
            case ".ttf": {
                return "application/x-font-ttf";
            }
            case ".woff": {
                return "application/x-font-woff";
            }
            case ".ico": {
                return "image/x-icon";
            }
        }
        return "text/plain;charset=UTF-8";
    }

    public static boolean support_templating(Path path) {
        switch (Resources.extension(path)) {
            case ".txt": 
            case ".md": 
            case ".markdown": 
            case ".html": 
            case ".xml": {
                return true;
            }
        }
        return false;
    }
}

