/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Env;
import net.codestory.http.templating.Site;

public class PreCompile {
    private final Site site;
    private final CompilerFacade compilers;

    public PreCompile(Env env) {
        this.site = new Site(env);
        this.compilers = new CompilerFacade(env);
    }

    public static void main(String[] args) {
        new PreCompile(new Env(true, false, false, false)).run();
    }

    public void run() {
        this.site.getResourceList().parallelStream().forEach(path -> this.preCompile((String)path));
    }

    protected void preCompile(String path) {
        String extension = Strings.extension(path);
        if (!this.compilers.canCompile(extension)) {
            return;
        }
        Path fromPath = Paths.get(path, new String[0]);
        Path toPath = this.toPath(path, extension);
        System.out.println("Pre-compile [" + fromPath + "] to [" + toPath + "]");
        try {
            byte[] bytes = this.compile(fromPath);
            this.write(bytes, toPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to pre-compile " + path);
        }
    }

    protected Path toPath(String path, String extension) {
        String compiledExtension = this.compilers.compiledExtension(extension);
        String newName = Strings.replaceLast(path, extension, compiledExtension);
        return Paths.get(Resources.APP_FOLDER, newName);
    }

    protected byte[] compile(Path fromPath) throws IOException {
        return this.compilers.compile(fromPath, Resources.read(fromPath, StandardCharsets.UTF_8)).toBytes();
    }

    protected void write(byte[] bytes, Path toPath) throws IOException {
        Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
        Files.write(toPath, bytes, new OpenOption[0]);
    }
}

